/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.PasteInCompilationUnitEdit;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.TypedSource;
import org.eclipse.jdt.internal.ui.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;

public class PasteSourceReferencesFromClipboardAction
extends SelectionDispatchAction {
    private Clipboard fClipboard;

    protected PasteSourceReferencesFromClipboardAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.fClipboard = clipboard;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    public boolean canOperateOn(IStructuredSelection selection) {
        try {
            if (selection.size() != 1) {
                return false;
            }
            if (!this.isAnythingToPaste()) {
                return false;
            }
            Object selected = selection.getFirstElement();
            if (selected instanceof IClassFile) {
                return false;
            }
            if (!(selected instanceof ISourceReference)) {
                return false;
            }
            if (!(selected instanceof IJavaElement)) {
                return false;
            }
            if (((IJavaElement)selected).isReadOnly()) {
                return false;
            }
            if (!((IJavaElement)selected).exists()) {
                return false;
            }
            IFile file = SourceReferenceUtil.getFile((ISourceReference)selected);
            if (file.isReadOnly()) {
                return false;
            }
            if (!file.isAccessible()) {
                return false;
            }
            if (selected instanceof IMember && ((IMember)selected).isBinary()) {
                return false;
            }
            ISourceReference workingCopyEl = this.getWorkingCopyElement((ISourceReference)selected);
            if (workingCopyEl == null || !((IJavaElement)workingCopyEl).exists()) {
                return false;
            }
            return this.canPaste((ISourceReference)selected, this.getContentsToPaste());
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }

    private boolean isAnythingToPaste() {
        TypedSource[] elems = this.getContentsToPaste();
        if (elems == null) {
            return false;
        }
        int i = 0;
        while (i < elems.length) {
            if (!this.isInterestingSourceReference(elems[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInterestingSourceReference(TypedSource je) {
        if (je.getType() == 6) {
            return false;
        }
        return je.getType() != 5;
    }

    protected TypedSource[] getContentsToPaste() {
        if (this.fClipboard == null) {
            return new TypedSource[0];
        }
        return (TypedSource[])this.fClipboard.getContents((Transfer)TypedSourceTransfer.getInstance());
    }

    private boolean canPaste(ISourceReference ref, TypedSource[] elements) {
        return this.canPasteIn(ref, elements) || this.canPasteAfter(ref, elements);
    }

    private ISourceReference getSelectedElement(IStructuredSelection selection) {
        return (ISourceReference)selection.getFirstElement();
    }

    public void run(final IStructuredSelection selection) {
        if (!this.canOperateOn(selection)) {
            return;
        }
        BusyIndicator.showWhile((Display)JavaPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PasteSourceReferencesFromClipboardAction.this.perform(PasteSourceReferencesFromClipboardAction.this.getSelectedElement(selection));
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e, ReorgMessages.getString("PasteSourceReferencesFromClipboardAction.paste1"), ReorgMessages.getString("PasteSourceReferencesFromClipboardAction.exception"));
                }
            }
        });
    }

    void perform(ISourceReference selected) throws CoreException {
        ISourceReference selectedWorkingCopyElement = this.getWorkingCopyElement(selected);
        if (selectedWorkingCopyElement == null || !((IJavaElement)selectedWorkingCopyElement).exists()) {
            return;
        }
        if (this.canPasteIn(selectedWorkingCopyElement, this.getContentsToPaste())) {
            if (selectedWorkingCopyElement instanceof ICompilationUnit) {
                this.pasteInCompilationUnit((ICompilationUnit)selectedWorkingCopyElement);
            } else {
                this.paste(2, selectedWorkingCopyElement);
            }
        } else if (this.canPasteAfter(selectedWorkingCopyElement, this.getContentsToPaste())) {
            this.paste(1, selectedWorkingCopyElement);
        } else {
            Assert.isTrue(false);
        }
    }

    private ISourceReference getWorkingCopyElement(ISourceReference selected) throws JavaModelException {
        ICompilationUnit cu = SourceReferenceUtil.getCompilationUnit(selected);
        ICompilationUnit workingCopy = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        return (ISourceReference)JavaModelUtil.findInCompilationUnit(workingCopy, (IJavaElement)selected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void paste(int style, ISourceReference selected) throws CoreException {
        TextBuffer tb;
        block5: {
            block4: {
                tb = TextBuffer.acquire(SourceReferenceUtil.getFile(selected));
                try {
                    TextBufferEditor tbe = new TextBufferEditor(tb);
                    TypedSource[] elems = this.getContentsToPaste();
                    IJavaElement element = (IJavaElement)selected;
                    int tabWidth = CodeFormatterUtil.getTabWidth();
                    int i = 0;
                    while (true) {
                        if (i >= elems.length) {
                            if (tbe.canPerformEdits().isOK()) break;
                            Object var11_11 = null;
                            if (tb == null) return;
                            break block4;
                        }
                        String[] sourceLines = Strings.removeTrailingEmptyLines(Strings.convertIntoLines(elems[i].getSource()));
                        MemberEdit edit = new MemberEdit(element, style, sourceLines, tabWidth);
                        tbe.add(edit);
                        ++i;
                    }
                    tbe.performEdits((IProgressMonitor)new NullProgressMonitor());
                    TextBuffer.commitChanges(tb, false, (IProgressMonitor)new NullProgressMonitor());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (tb == null) throw throwable;
                    TextBuffer.release(tb);
                    throw throwable;
                }
            }
            TextBuffer.release(tb);
            return;
        }
        Object var11_13 = null;
        if (tb == null) return;
        TextBuffer.release(tb);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pasteInCompilationUnit(ICompilationUnit unit) throws CoreException {
        TextBuffer tb;
        block5: {
            block4: {
                tb = TextBuffer.acquire(SourceReferenceUtil.getFile((ISourceReference)unit));
                try {
                    TextBufferEditor tbe = new TextBufferEditor(tb);
                    TypedSource[] elems = this.getContentsToPaste();
                    int i = 0;
                    while (true) {
                        if (i >= elems.length) {
                            if (tbe.canPerformEdits().isOK()) break;
                            Object var6_6 = null;
                            if (tb == null) return;
                            break block4;
                        }
                        tbe.add(new PasteInCompilationUnitEdit(elems[i].getSource(), elems[i].getType(), unit));
                        ++i;
                    }
                    tbe.performEdits((IProgressMonitor)new NullProgressMonitor());
                    TextBuffer.commitChanges(tb, false, (IProgressMonitor)new NullProgressMonitor());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (tb == null) throw throwable;
                    TextBuffer.release(tb);
                    throw throwable;
                }
            }
            TextBuffer.release(tb);
            return;
        }
        Object var6_8 = null;
        if (tb == null) return;
        TextBuffer.release(tb);
    }

    private boolean canPasteAfter(ISourceReference ref, TypedSource[] elements) {
        if (ref instanceof ICompilationUnit) {
            return false;
        }
        if (ref instanceof IImportContainer) {
            return this.canPasteAtTopLevel(elements);
        }
        if (ref instanceof IImportDeclaration) {
            return this.canPasteAtTopLevel(elements);
        }
        if (ref instanceof IPackageDeclaration) {
            return this.canPasteAtTopLevel(elements);
        }
        if (ref instanceof IType) {
            return this.canPasteAfterType(elements);
        }
        if (ref instanceof IMember) {
            return this.canPasteAfterMember(elements);
        }
        return false;
    }

    private boolean canPasteAfterType(TypedSource[] elems) {
        return this.areAllValuesOfType(elems, 7);
    }

    private boolean canPasteAtTopLevel(TypedSource[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.canPasteAfterImportContainerOrDeclaration(elements[i].getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canPasteAfterImportContainerOrDeclaration(int type) {
        if (type == 12) {
            return true;
        }
        if (type == 13) {
            return true;
        }
        return type == 7;
    }

    private boolean canPasteAfterMember(TypedSource[] elems) {
        return this.areAllMembers(elems);
    }

    private boolean canPasteIn(ISourceReference ref, TypedSource[] elements) {
        if (ref instanceof IImportContainer) {
            return this.canPasteInImportContainer(elements);
        }
        if (ref instanceof IType) {
            return this.canPasteInType(elements);
        }
        if (ref instanceof ICompilationUnit) {
            return this.canPasteInCompilationUnit(elements);
        }
        return false;
    }

    private boolean canPasteInImportContainer(TypedSource[] elements) {
        return false;
    }

    private boolean canPasteInType(TypedSource[] elements) {
        return this.areAllMembers(elements);
    }

    private boolean canPasteInCompilationUnit(TypedSource[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.canPasteInCompilationUnit(elements[i].getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canPasteInCompilationUnit(int type) {
        if (type == 12) {
            return true;
        }
        if (type == 13) {
            return true;
        }
        if (type == 11) {
            return true;
        }
        return type == 7;
    }

    private boolean areAllValuesOfType(TypedSource[] elements, int type) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getType() != type) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areAllMembers(TypedSource[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.isMember(elements[i].getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isMember(int type) {
        if (type == 8) {
            return true;
        }
        if (type == 10) {
            return true;
        }
        if (type == 9) {
            return true;
        }
        return type == 7;
    }
}

