/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.JdtCopyAction;
import org.eclipse.jdt.internal.ui.reorg.ReorgActionFactory;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.reorg.StructuredSelectionUtil;
import org.eclipse.jdt.internal.ui.reorg.TypedSource;
import org.eclipse.jdt.internal.ui.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteResourcesFromClipboardAction
extends SelectionDispatchAction {
    private Clipboard fClipboard;

    protected PasteResourcesFromClipboardAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        Assert.isNotNull(clipboard);
        this.fClipboard = clipboard;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    public void run(IStructuredSelection selection) {
        IResource[] resourceData = this.getClipboardResources();
        if (resourceData == null || resourceData.length == 0) {
            if (this.canPasteFiles(selection)) {
                this.pasteFiles(selection.getFirstElement());
            }
            return;
        }
        this.pasteResources(selection, resourceData);
    }

    private void pasteFiles(Object target) {
        String[] fileData = this.getClipboardFiles();
        if (fileData == null) {
            return;
        }
        IContainer container = this.convertToContainer(target);
        if (container == null) {
            return;
        }
        new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(fileData, container);
    }

    private IContainer convertToContainer(Object target) {
        if (target instanceof IContainer) {
            return (IContainer)target;
        }
        try {
            return (IContainer)((IJavaElement)target).getCorrespondingResource();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("PasteResourcesFromClipboardAction.error.title"), ReorgMessages.getString("PasteResourcesFromClipboardAction.error.message"));
            return null;
        }
    }

    private void pasteResources(IStructuredSelection selection, IResource[] resourceData) {
        if (resourceData[0].getType() == 4) {
            this.pasteProject((IProject)resourceData[0]);
        } else {
            ReorgActionFactory.createDnDCopyAction(resourceData, this.getFirstSelectedResource(selection)).run();
        }
    }

    private void pasteProject(IProject project) {
        CopyProjectAction cpa = new CopyProjectAction(this.getShell());
        cpa.selectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
        if (!cpa.isEnabled()) {
            return;
        }
        cpa.run();
    }

    private boolean canOperateOn(IStructuredSelection selection) {
        IResource[] resourceData = this.getClipboardResources();
        if (resourceData == null || resourceData.length == 0) {
            return this.canPasteFiles(selection);
        }
        if (ClipboardActionUtil.isOneOpenProject(resourceData)) {
            return true;
        }
        if (selection.size() != 1) {
            return false;
        }
        TypedSource[] typedSource = this.getClipboardSourceReference();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProject && !((IProject)firstElement).isOpen()) {
            return false;
        }
        if (firstElement instanceof ICompilationUnit && typedSource != null && typedSource.length != 0) {
            return false;
        }
        if (StructuredSelectionUtil.getResources(selection).length != 1) {
            return false;
        }
        if (resourceData == null) {
            return ClipboardActionUtil.getFirstResource(selection) instanceof IContainer;
        }
        if (!PasteResourcesFromClipboardAction.allResourcesExist(resourceData)) {
            return false;
        }
        return PasteResourcesFromClipboardAction.canActivateCopyRefactoring(this.getShell(), resourceData, ClipboardActionUtil.getFirstResource(selection));
    }

    private static boolean allResourcesExist(IResource[] resourceData) {
        int i = 0;
        while (i < resourceData.length) {
            if (!resourceData[i].exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canPasteFiles(IStructuredSelection selection) {
        String[] clipboardFiles = this.getClipboardFiles();
        return clipboardFiles != null && PasteResourcesFromClipboardAction.canPasteFilesOn(selection.getFirstElement());
    }

    private static boolean canPasteFilesOn(Object target) {
        IJavaElement element;
        IContainer container;
        boolean isPackageFragment = target instanceof IPackageFragment;
        boolean isJavaProject = target instanceof IJavaProject;
        boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
        boolean isContainer = target instanceof IContainer;
        if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
            return false;
        }
        return isContainer ? !(container = (IContainer)target).isReadOnly() : !(element = (IJavaElement)target).isReadOnly();
    }

    private static boolean canActivateCopyRefactoring(Shell shell, IResource[] resourceData, IResource selectedResource) {
        try {
            CopyRefactoring ref = PasteResourcesFromClipboardAction.createCopyRefactoring(shell, resourceData);
            if (!ref.checkActivation((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                return false;
            }
            return ref.isValidDestination(ClipboardActionUtil.tryConvertingToJava(selectedResource));
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private IResource getFirstSelectedResource(IStructuredSelection selection) {
        return ClipboardActionUtil.getFirstResource(selection);
    }

    private String[] getClipboardFiles() {
        return (String[])this.fClipboard.getContents((Transfer)FileTransfer.getInstance());
    }

    private IResource[] getClipboardResources() {
        return (IResource[])this.fClipboard.getContents((Transfer)ResourceTransfer.getInstance());
    }

    private TypedSource[] getClipboardSourceReference() {
        return (TypedSource[])this.fClipboard.getContents((Transfer)TypedSourceTransfer.getInstance());
    }

    private static CopyRefactoring createCopyRefactoring(Shell shell, IResource[] resourceData) {
        IPackageFragmentRootManipulationQuery query = JdtCopyAction.createUpdateClasspathQuery(shell);
        return new CopyRefactoring(ClipboardActionUtil.getConvertedResources(resourceData), new ReorgQueries(), query);
    }
}

