/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

final class PasteInCompilationUnitEdit
extends SimpleTextEdit {
    private String fSource;
    private int fType;
    private ICompilationUnit fCu;

    protected PasteInCompilationUnitEdit(String source, int type, ICompilationUnit cu) {
        Assert.isNotNull(source);
        this.fSource = source;
        Assert.isTrue(type == 11 || type == 12 || type == 13 || type == 7);
        this.fType = type;
        Assert.isTrue(cu.exists());
        this.fCu = cu;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new PasteInCompilationUnitEdit(this.fSource, this.fType, this.fCu);
    }

    public void connect(TextBuffer buffer) throws CoreException {
        this.setText(this.fSource);
        this.setTextRange(new TextRange(this.computeOffset(), 0));
        super.connect(buffer);
    }

    private int computeOffset() throws JavaModelException {
        switch (this.fType) {
            case 11: {
                return this.computeOffsetForPackageDeclaration();
            }
            case 12: {
                return this.computeOffsetForImportContainer();
            }
            case 13: {
                return this.computeOffsetForImportContainer();
            }
            case 7: {
                return this.computeOffsetForType();
            }
        }
        Assert.isTrue(false);
        return -1;
    }

    private int computeOffsetForPackageDeclaration() throws JavaModelException {
        IPackageDeclaration[] declarations = this.fCu.getPackageDeclarations();
        if (declarations.length == 0) {
            return 0;
        }
        return declarations[0].getSourceRange().getOffset();
    }

    private int computeOffsetForImportContainer() throws JavaModelException {
        IImportContainer container = this.fCu.getImportContainer();
        if (container.exists()) {
            return container.getSourceRange().getOffset();
        }
        IPackageDeclaration[] declarations = this.fCu.getPackageDeclarations();
        if (declarations.length != 0) {
            return declarations[declarations.length - 1].getSourceRange().getOffset() + declarations[declarations.length - 1].getSourceRange().getLength();
        }
        return 0;
    }

    private int computeOffsetForType() throws JavaModelException {
        IType[] types = this.fCu.getTypes();
        if (types.length != 0) {
            return types[0].getSourceRange().getOffset();
        }
        return this.fCu.getSourceRange().getLength();
    }
}

