/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.text.MessageFormat;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.ui.dialogs.ListDialog;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

class PackageFragmentRootManipulationQuery
implements IPackageFragmentRootManipulationQuery {
    private final Shell fShell;
    private final String fDialogTitle;
    private final String fMessagePattern;

    PackageFragmentRootManipulationQuery(Shell shell, String dialogTitle, String messagePattern) {
        Assert.isNotNull(shell);
        Assert.isNotNull(dialogTitle);
        Assert.isNotNull(messagePattern);
        this.fShell = shell;
        this.fDialogTitle = dialogTitle;
        this.fMessagePattern = messagePattern;
    }

    public boolean confirmManipulation(IPackageFragmentRoot root, IJavaProject[] referencingProjects) {
        String msg = MessageFormat.format(this.fMessagePattern, root.getElementName());
        ReferencingProjectListDialog dialog = new ReferencingProjectListDialog(this.fShell);
        dialog.setBlockOnOpen(true);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        dialog.setInput(referencingProjects);
        dialog.setMessage(msg);
        dialog.setTitle(this.fDialogTitle);
        return dialog.open() == 0;
    }

    private static final class ReferencingProjectListDialog
    extends ListDialog {
        ReferencingProjectListDialog(Shell parent) {
            super(parent, 2096);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
        }
    }
}

