/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.PackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.ui.reorg.ReorgDestinationAction;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class JdtMoveAction
extends ReorgDestinationAction {
    public static final int PREVIEW_ID = 1025;
    private static final String DEFAULT_PACKAGE_WARNING = "DefaultPackageWarningDialog";
    private boolean fShowPreview = false;

    public JdtMoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.getString("moveAction.label"));
    }

    protected void run(IStructuredSelection selection) {
        if (ClipboardActionUtil.hasOnlyProjects(selection)) {
            this.moveProject(selection);
        } else {
            super.run(selection);
        }
    }

    public static ElementTreeSelectionDialog makeDialog(Shell parent, MoveRefactoring refactoring) {
        ReorgDestinationAction.DestinationDialogContentProvider cp = new ReorgDestinationAction.DestinationDialogContentProvider();
        MoveDestinationDialog dialog = new MoveDestinationDialog(parent, (ILabelProvider)new ReorgDestinationAction.DestinationRenderer(256), cp, refactoring);
        return dialog;
    }

    String getActionName() {
        return ReorgMessages.getString("moveAction.name");
    }

    String getDestinationDialogMessage() {
        return ReorgMessages.getString("moveAction.destination.label");
    }

    ReorgRefactoring createRefactoring(List elements) {
        IPackageFragmentRootManipulationQuery query = JdtMoveAction.createUpdateClasspathQuery(this.getShell());
        return new MoveRefactoring(elements, JavaPreferencesSettings.getCodeGenerationSettings(), query);
    }

    ElementTreeSelectionDialog createDestinationSelectionDialog(Shell parent, ILabelProvider labelProvider, StandardJavaElementContentProvider cp, ReorgRefactoring refactoring) {
        return new MoveDestinationDialog(parent, labelProvider, cp, (MoveRefactoring)refactoring);
    }

    protected boolean isOkToProceed(ReorgRefactoring refactoring) throws JavaModelException {
        return JdtMoveAction.isOkToMoveReadOnly(refactoring);
    }

    protected void setShowPreview(boolean showPreview) {
        this.fShowPreview = showPreview;
    }

    private static boolean isOkToMoveReadOnly(ReorgRefactoring refactoring) {
        if (!JdtMoveAction.hasReadOnlyElements(refactoring)) {
            return true;
        }
        if (refactoring.getDestination() instanceof IPackageFragment) {
            List list = refactoring.getElementsToReorg();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof ICompilationUnit) continue;
                return JdtMoveAction.askIfOkToMoveReadOnly();
            }
            return true;
        }
        return JdtMoveAction.askIfOkToMoveReadOnly();
    }

    private static boolean askIfOkToMoveReadOnly() {
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.getString("moveAction.checkMove"), (String)ReorgMessages.getString("moveAction.error.readOnly"));
    }

    private static boolean hasReadOnlyElements(ReorgRefactoring refactoring) {
        Iterator iter = refactoring.getElementsToReorg().iterator();
        while (iter.hasNext()) {
            if (!ReorgUtils.shouldConfirmReadOnly(iter.next())) continue;
            return true;
        }
        return false;
    }

    protected Object openDialog(ElementTreeSelectionDialog dialog) {
        Object result = super.openDialog(dialog);
        this.fShowPreview = dialog instanceof MoveDestinationDialog ? dialog.getReturnCode() == 1025 : false;
        return result;
    }

    void reorg(ReorgRefactoring refactoring) throws JavaModelException {
        if (!this.showWarningAboutDefaultPackages(refactoring)) {
            return;
        }
        if (this.fShowPreview) {
            JdtMoveAction.openWizard(this.getShell(), refactoring);
            return;
        }
        super.reorg(refactoring);
    }

    private boolean showWarningAboutDefaultPackages(ReorgRefactoring refactoring) {
        try {
            List elementsToMove;
            IPackageFragment destination = ReorgRefactoring.getDestinationAsPackageFragment(refactoring.getDestination());
            if (!JavaElementUtil.isDefaultPackage(destination) && !JdtMoveAction.containsAnyCusFromDefaultPackage(elementsToMove = JdtMoveAction.getNotExcluded(refactoring.getElementsToReorg(), refactoring.getExcludedElements()))) {
                return true;
            }
            int result = OptionalMessageDialog.open(DEFAULT_PACKAGE_WARNING, this.getShell(), ReorgMessages.getString("JdtMoveAction.move"), null, ReorgMessages.getString("JdtMoveAction.default_package_warning"), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            return result != 1;
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("JdtMoveAction.move"), ReorgMessages.getString("JdtMoveAction.exception"));
            return false;
        }
    }

    private static boolean containsAnyCusFromDefaultPackage(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ICompilationUnit) || !JavaElementUtil.isDefaultPackage(((ICompilationUnit)element).getParent())) continue;
            return true;
        }
        return false;
    }

    private static List getNotExcluded(Collection elements, Collection excluded) {
        ArrayList result = new ArrayList(elements.size());
        result.addAll(elements);
        result.removeAll(excluded);
        return result;
    }

    public static void openWizard(Shell parent, ReorgRefactoring refactoring) {
        RefactoringWizard wizard = new RefactoringWizard(refactoring, ReorgMessages.getString("JdtMoveAction.move"), "org.eclipse.jdt.ui.move_cu_error_wizard_page_context");
        wizard.setChangeCreationCancelable(false);
        new RefactoringWizardDialog(parent, wizard).open();
    }

    private void moveProject(IStructuredSelection selection) {
        MoveProjectAction action = new MoveProjectAction(JavaPlugin.getActiveWorkbenchShell());
        action.selectionChanged(selection);
        action.run();
    }

    public static IPackageFragmentRootManipulationQuery createUpdateClasspathQuery(Shell shell) {
        String messagePattern = String.valueOf(ReorgMessages.getString("JdtMoveAction.referenced")) + ReorgMessages.getString("JdtMoveAction.update_classpath");
        return new PackageFragmentRootManipulationQuery(shell, ReorgMessages.getString("JdtMoveAction.Move"), messagePattern);
    }

    private static class MoveDestinationDialog
    extends ElementTreeSelectionDialog {
        private MoveRefactoring fRefactoring;
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private Button fPreview;

        MoveDestinationDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, MoveRefactoring refactoring) {
            super(parent, labelProvider, contentProvider);
            this.fRefactoring = refactoring;
            this.setDoubleClickSelects(false);
        }

        protected void updateOKStatus() {
            super.updateOKStatus();
            try {
                boolean preview;
                Button okButton = this.getOkButton();
                boolean okEnabled = okButton.getEnabled();
                this.fRefactoring.setDestination(this.getFirstResult());
                this.fReferenceCheckbox.setEnabled(okEnabled && this.canUpdateReferences());
                this.fRefactoring.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
                if (this.fQualifiedNameCheckbox != null) {
                    boolean enabled = okEnabled && this.fRefactoring.canEnableQualifiedNameUpdating();
                    this.fQualifiedNameCheckbox.setEnabled(enabled);
                    if (enabled) {
                        this.fQualifiedNameComponent.setEnabled(this.fRefactoring.getUpdateQualifiedNames());
                        if (this.fRefactoring.getUpdateQualifiedNames()) {
                            okButton.setEnabled(false);
                        }
                    } else {
                        this.fQualifiedNameComponent.setEnabled(false);
                    }
                    this.fRefactoring.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
                }
                if (preview = okEnabled) {
                    preview = this.fRefactoring.getUpdateQualifiedNames() && this.fRefactoring.canEnableQualifiedNameUpdating() || this.fReferenceCheckbox.getSelection() && this.fRefactoring.canUpdateReferences();
                }
                this.fPreview.setEnabled(preview);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("JdtMoveAction.move"), ReorgMessages.getString("JdtMoveAction.exception"));
            }
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1025) {
                this.setReturnCode(1025);
                this.close();
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.move_destination_dialog_context");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fPreview = this.createButton(parent, 1025, ReorgMessages.getString("JdtMoveAction.preview"), false);
            super.createButtonsForButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.addUpdateReferenceComponent(result);
            this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            Dialog.applyDialogFont((Control)result);
            return result;
        }

        private void addUpdateReferenceComponent(Composite result) {
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.getString("JdtMoveAction.update_references"));
            this.fReferenceCheckbox.setSelection(this.fRefactoring.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MoveDestinationDialog this$1;
                {
                    this.this$1 = moveDestinationDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveDestinationDialog.access$0(this.this$1).setUpdateReferences(((Button)e.widget).getSelection());
                    this.this$1.updateOKStatus();
                }
            });
        }

        private boolean canUpdateReferences() {
            try {
                return this.fRefactoring.canUpdateReferences();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            if (!this.fRefactoring.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(this.fRefactoring.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, this.fRefactoring, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.fQualifiedNameComponent.setEnabled(false);
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MoveDestinationDialog this$1;
                {
                    this.this$1 = moveDestinationDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    MoveDestinationDialog.access$1(this.this$1).setEnabled(enabled);
                    MoveDestinationDialog.access$0(this.this$1).setUpdateQualifiedNames(enabled);
                    this.this$1.updateOKStatus();
                }
            });
        }

        protected IDialogSettings getRefactoringSettings() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            if (settings == null) {
                return null;
            }
            IDialogSettings result = settings.getSection("org.eclipse.jdt.ui.refactoring");
            if (result == null) {
                result = new DialogSettings("org.eclipse.jdt.ui.refactoring");
                settings.addSection(result);
            }
            return result;
        }

        public boolean close() {
            if (this.getReturnCode() != 1 && this.fQualifiedNameComponent != null) {
                this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
            }
            return super.close();
        }

        static /* synthetic */ MoveRefactoring access$0(MoveDestinationDialog moveDestinationDialog) {
            return moveDestinationDialog.fRefactoring;
        }

        static /* synthetic */ QualifiedNameComponent access$1(MoveDestinationDialog moveDestinationDialog) {
            return moveDestinationDialog.fQualifiedNameComponent;
        }
    }
}

