/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

class DualReorgAction
extends SelectionDispatchAction {
    SelectionDispatchAction fResourceAction;
    SelectionDispatchAction fSourceReferenceAction;

    protected DualReorgAction(IWorkbenchSite site, String text, String description, SelectionDispatchAction resourceAction, SelectionDispatchAction sourceReferenceAction, String helpContextID) {
        super(site);
        this.setText(text);
        this.setDescription(description);
        this.fResourceAction = resourceAction;
        this.fSourceReferenceAction = sourceReferenceAction;
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)helpContextID);
    }

    public void run() {
        if (this.fResourceAction.isEnabled()) {
            this.fResourceAction.run();
        } else if (this.fSourceReferenceAction.isEnabled()) {
            this.fSourceReferenceAction.run();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fResourceAction.selectionChanged(event);
        this.fSourceReferenceAction.selectionChanged(event);
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        this.fResourceAction.update(selection);
        this.fSourceReferenceAction.update(selection);
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (!this.fResourceAction.isEnabled() && !this.fSourceReferenceAction.isEnabled()) {
            return false;
        }
        return !this.fResourceAction.isEnabled() || !this.fSourceReferenceAction.isEnabled();
    }
}

