/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteSourceReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.SourceReferenceAction;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeleteSourceReferencesAction
extends SourceReferenceAction {
    private boolean fCanDeleteGetterSetter = true;
    private boolean fAskForDeleteConfirmation = true;

    public DeleteSourceReferencesAction(IWorkbenchSite site) {
        super(site);
    }

    public void setCanDeleteGetterSetter(boolean canDelete) {
        this.fCanDeleteGetterSetter = canDelete;
    }

    public void setAskForDeleteConfirmation(boolean ask) {
        this.fAskForDeleteConfirmation = ask;
    }

    protected void perform(IStructuredSelection selection) throws CoreException {
        if (this.fAskForDeleteConfirmation && !DeleteSourceReferencesAction.confirmDelete(selection)) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, this.createDeleteOperation(selection));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ReorgMessages.getString("DeleteSourceReferenceAction.error.title"), ReorgMessages.getString("DeleteSourceReferenceAction.error.message"));
        }
        catch (InterruptedException interruptedException) {}
    }

    private IRunnableWithProgress createDeleteOperation(final IStructuredSelection selection) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        JavaCore.run((IWorkspaceRunnable)DeleteSourceReferencesAction.this.createDeleteRunnable(selection), (IProgressMonitor)pm);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    pm.done();
                    throw throwable;
                }
                Object var3_5 = null;
                pm.done();
            }
        };
    }

    private IWorkspaceRunnable createDeleteRunnable(final IStructuredSelection selection) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                Map mapping = SourceReferenceUtil.groupByFile(DeleteSourceReferencesAction.this.getElementsToProcess(selection));
                int size = mapping.keySet().size();
                pm.beginTask(ReorgMessages.getString("DeleteSourceReferenceAction.deleting"), 3 * size);
                if (DeleteSourceReferencesAction.areAllFilesReadOnly(mapping)) {
                    String title = ReorgMessages.getString("DeleteSourceReferencesAction.title");
                    String label = ReorgMessages.getString("DeleteSourceReferencesAction.read_only");
                    MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)label);
                    return;
                }
                List<ICompilationUnit> emptyCuList = Arrays.asList(DeleteSourceReferencesAction.getCusLeftEmpty(mapping));
                Iterator iter = mapping.keySet().iterator();
                while (iter.hasNext()) {
                    IFile file = (IFile)iter.next();
                    if (emptyCuList.contains(JavaCore.create((IFile)file)) || DeleteSourceReferencesAction.isReadOnly(file)) continue;
                    DeleteSourceReferencesAction.deleteAll(mapping, file, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                ICompilationUnit[] notDeleted = DeleteSourceReferencesAction.this.deleteEmptyCus(mapping, (IProgressMonitor)new SubProgressMonitor(pm, size));
                int i = 0;
                while (i < notDeleted.length) {
                    IFile file = (IFile)notDeleted[i].getResource();
                    if (!DeleteSourceReferencesAction.isReadOnly(file)) {
                        DeleteSourceReferencesAction.deleteAll(mapping, file, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    ++i;
                }
            }
        };
    }

    private static boolean isReadOnly(IFile file) {
        if (!file.isReadOnly()) {
            return false;
        }
        return !ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null).isOK();
    }

    private static boolean areAllFilesReadOnly(Map mapping) {
        Iterator iter = mapping.keySet().iterator();
        while (iter.hasNext()) {
            if (DeleteSourceReferencesAction.isReadOnly((IFile)iter.next())) continue;
            return false;
        }
        return true;
    }

    private static void deleteAll(Map mapping, IFile file, IProgressMonitor pm) throws CoreException {
        List l = (List)mapping.get(file);
        ISourceReference[] refs = l.toArray(new ISourceReference[l.size()]);
        pm.beginTask("", refs.length);
        ISourceReference[] nonFields = DeleteSourceReferencesAction.getNonFields(refs);
        DeleteSourceReferencesAction.delete(file, nonFields, (IProgressMonitor)new SubProgressMonitor(pm, nonFields.length));
        IField[] fields = DeleteSourceReferencesAction.getFields(refs);
        DeleteSourceReferencesAction.delete(fields, (IProgressMonitor)new SubProgressMonitor(pm, fields.length));
        pm.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void delete(IFile file, ISourceReference[] nonFields, IProgressMonitor pm) throws CoreException {
        TextBuffer tb;
        block9: {
            block7: {
                block8: {
                    pm.beginTask("", 2);
                    tb = TextBuffer.acquire(file);
                    try {
                        TextBufferEditor tbe = new TextBufferEditor(tb);
                        int i = 0;
                        while (true) {
                            if (i >= nonFields.length) {
                                if (tbe.canPerformEdits().isOK()) break;
                                Object var6_6 = null;
                                if (tb == null) break block7;
                                break block8;
                            }
                            Assert.isTrue(!(nonFields[i] instanceof IField));
                            tbe.add(DeleteSourceReferencesAction.createDeleteEdit(nonFields[i]));
                            if (pm.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            ++i;
                        }
                        tbe.performEdits((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        TextBuffer.commitChanges(tb, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (tb != null) {
                            TextBuffer.release(tb);
                        }
                        pm.done();
                        throw throwable;
                    }
                }
                TextBuffer.release(tb);
            }
            pm.done();
            return;
        }
        Object var6_8 = null;
        if (tb != null) {
            TextBuffer.release(tb);
        }
        pm.done();
    }

    private static void delete(IField[] fields, IProgressMonitor pm) throws JavaModelException {
        if (fields.length != 0) {
            DeleteSourceReferencesAction.getJavaModel().delete((IJavaElement[])fields, false, pm);
        }
    }

    private static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    private static TextEdit createDeleteEdit(ISourceReference ref) throws JavaModelException {
        ICompilationUnit cu = SourceReferenceUtil.getCompilationUnit(ref);
        cu.reconcile();
        return new DeleteSourceReferenceEdit(ref, cu);
    }

    private ICompilationUnit[] deleteEmptyCus(Map mapping, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit[] cusToDelete = DeleteSourceReferencesAction.getCusLeftEmpty(mapping);
        if (cusToDelete.length == 0) {
            return cusToDelete;
        }
        if (!this.confirmCusDelete(cusToDelete)) {
            return cusToDelete;
        }
        ArrayList<ICompilationUnit> notDeletedCus = new ArrayList<ICompilationUnit>();
        notDeletedCus.addAll(Arrays.asList(cusToDelete));
        pm.beginTask("", cusToDelete.length);
        int i = 0;
        while (i < cusToDelete.length) {
            if (!DeleteSourceReferencesAction.isReadOnly(cusToDelete[i]) || DeleteSourceReferencesAction.isOkToDeleteReadOnly(cusToDelete[i])) {
                cusToDelete[i].delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                notDeletedCus.remove(cusToDelete[i]);
            }
            ++i;
        }
        pm.done();
        return notDeletedCus.toArray(new ICompilationUnit[notDeletedCus.size()]);
    }

    private static boolean isReadOnly(ICompilationUnit cu) throws JavaModelException {
        if (cu.isReadOnly()) {
            return true;
        }
        return cu.getResource().isReadOnly();
    }

    private static boolean isOkToDeleteReadOnly(ICompilationUnit cu) {
        String message = ReorgMessages.getFormattedString("DeleteSourceReferencesAction.cu_read_only", DeleteSourceReferencesAction.getName(cu));
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.getString("DeleteSourceReferencesAction.delete1"), (String)message);
    }

    private static ICompilationUnit[] getCusLeftEmpty(Map mapping) throws JavaModelException {
        ArrayList<ICompilationUnit> cuList = new ArrayList<ICompilationUnit>();
        Iterator iter = mapping.keySet().iterator();
        while (iter.hasNext()) {
            List sourceReferences;
            ICompilationUnit cu;
            IFile file = (IFile)iter.next();
            IJavaElement el = JavaCore.create((IFile)file);
            if (el == null || el.getElementType() != 5 || !DeleteSourceReferencesAction.willBeLeftEmpty(cu = (ICompilationUnit)el, sourceReferences = (List)mapping.get(file))) continue;
            cuList.add(cu);
        }
        return cuList.toArray(new ICompilationUnit[cuList.size()]);
    }

    private static boolean willBeLeftEmpty(ICompilationUnit cu, List sourceReferences) throws JavaModelException {
        IType[] cuTypes = WorkingCopyUtil.getWorkingCopyIfExists(cu).getTypes();
        int i = 0;
        while (i < cuTypes.length) {
            if (!sourceReferences.contains(cuTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected ISourceReference[] getElementsToProcess(IStructuredSelection selection) {
        ISourceReference[] elements = super.getElementsToProcess(selection);
        if (!this.fCanDeleteGetterSetter) {
            return elements;
        }
        IField[] fields = DeleteSourceReferencesAction.getFields(elements);
        if (fields.length == 0) {
            return elements;
        }
        IMethod[] gettersSetters = DeleteSourceReferencesAction.getGettersSettersForFields(fields);
        if (gettersSetters.length == 0) {
            return elements;
        }
        HashSet<IMethod> getterSetterSet = new HashSet<IMethod>(Arrays.asList(gettersSetters));
        getterSetterSet.removeAll(Arrays.asList(elements));
        if (getterSetterSet.isEmpty()) {
            return elements;
        }
        if (!this.confirmGetterSetterDelete()) {
            return elements;
        }
        HashSet<ISourceReference> newElementSet = new HashSet<ISourceReference>(Arrays.asList(elements));
        newElementSet.addAll(getterSetterSet);
        return newElementSet.toArray(new ISourceReference[newElementSet.size()]);
    }

    private static ISourceReference[] getNonFields(ISourceReference[] elements) {
        ArrayList<ISourceReference> nonFields = new ArrayList<ISourceReference>();
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof IField)) {
                nonFields.add(elements[i]);
            }
            ++i;
        }
        return nonFields.toArray(new ISourceReference[nonFields.size()]);
    }

    private static IField[] getFields(ISourceReference[] elements) {
        ArrayList<ISourceReference> fields = new ArrayList<ISourceReference>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IField) {
                fields.add(elements[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IMethod[] getGettersSettersForFields(IField[] fields) {
        try {
            ArrayList<IMethod> gettersSetters = new ArrayList<IMethod>();
            int i = 0;
            while (i < fields.length) {
                IMethod setter;
                IMethod getter = GetterSetterUtil.getGetter(fields[i]);
                if (getter != null && getter.exists()) {
                    gettersSetters.add(getter);
                }
                if ((setter = GetterSetterUtil.getSetter(fields[i])) != null && setter.exists()) {
                    gettersSetters.add(setter);
                }
                ++i;
            }
            return gettersSetters.toArray(new IMethod[gettersSetters.size()]);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), JavaPlugin.getActiveWorkbenchShell(), ReorgMessages.getString("DeleteSourceReferencesAction.delete_elements"), ReorgMessages.getString("DeleteSourceReferencesAction.exception"));
            return new IMethod[0];
        }
    }

    private static boolean confirmDelete(IStructuredSelection selection) {
        String label;
        String title = ReorgMessages.getString("deleteAction.confirm.title");
        if (selection.size() == 1) {
            String[] keys = new String[]{DeleteSourceReferencesAction.getName(selection.getFirstElement())};
            label = ReorgMessages.getFormattedString("DeleteSourceReferencesAction.sure", keys);
        } else {
            String[] keys = new String[]{String.valueOf(selection.size())};
            label = ReorgMessages.getFormattedString("DeleteSourceReferencesAction.sure_elements", keys);
        }
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)label);
    }

    private static String getName(Object element) {
        if (element instanceof IJavaElement) {
            JavaElementLabelProvider lp = new JavaElementLabelProvider();
            String text = lp.getText(element);
            lp.dispose();
            return text;
        }
        return ReorgUtils.getName(element);
    }

    protected boolean confirmCusDelete(ICompilationUnit[] cusToDelete) {
        String message = cusToDelete.length == 1 ? ReorgMessages.getFormattedString("DeleteSourceReferencesAction.cu_empty", DeleteSourceReferencesAction.getName(cusToDelete[0])) : ReorgMessages.getFormattedString("DeleteSourceReferencesAction.cus_empty", String.valueOf(cusToDelete.length));
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.getString("DeleteSourceReferencesAction.delete1"), (String)message);
    }

    protected boolean confirmGetterSetterDelete() {
        String title = ReorgMessages.getString("DeleteSourceReferencesAction.confirm_gs_delete");
        String label = ReorgMessages.getString("DeleteSourceReferencesAction.delete_gs");
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        return MessageDialog.openQuestion((Shell)parent, (String)title, (String)label);
    }

    protected boolean canWorkOn(Object element) throws JavaModelException {
        if (!super.canWorkOn(element)) {
            return false;
        }
        return !(element instanceof IMember) || !((IMember)element).isBinary();
    }
}

