/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.PackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeleteResourcesAction
extends SelectionDispatchAction {
    protected DeleteResourcesAction(IWorkbenchSite site) {
        super(site);
    }

    protected void run(IStructuredSelection selection) {
        if (ClipboardActionUtil.hasOnlyProjects(selection)) {
            DeleteResourcesAction.deleteProjects(selection);
            return;
        }
        DeleteRefactoring refactoring = new DeleteRefactoring(selection.toList(), this.createRootManipulationQuery());
        try {
            if (!DeleteResourcesAction.confirmDelete(selection)) {
                return;
            }
            if (DeleteResourcesAction.hasReadOnlyResources(selection) && !DeleteResourcesAction.isOkToDeleteReadOnly()) {
                return;
            }
            if (!DeleteResourcesAction.confirmDeleteSourceFolderAsSubresource(selection)) {
                return;
            }
            MultiStatus status = ClipboardActionUtil.perform(refactoring);
            if (!status.isOK()) {
                JavaPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.getString("DeleteResourceAction.delete"), (String)ReorgMessages.getString("DeleteResourceAction.exception"), (IStatus)status);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, ReorgMessages.getString("DeleteResourceAction.delete"), ReorgMessages.getString("DeleteResourceAction.exception"));
            return;
        }
    }

    private IPackageFragmentRootManipulationQuery createRootManipulationQuery() {
        String messagePattern = ReorgMessages.getString("DeleteResourcesAction.referenced");
        return new PackageFragmentRootManipulationQuery(this.getShell(), ReorgMessages.getString("DeleteResourcesAction.Delete"), messagePattern);
    }

    private static void deleteProjects(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction(JavaPlugin.getActiveWorkbenchShell());
        action.selectionChanged(selection);
        action.run();
    }

    private static boolean isOkToDeleteReadOnly() {
        String msg = ReorgMessages.getString("deleteAction.confirmReadOnly");
        String title = ReorgMessages.getString("deleteAction.checkDeletion");
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)msg);
    }

    private static boolean hasReadOnlyResources(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (!ReorgUtils.shouldConfirmReadOnly(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean confirmDeleteSourceFolderAsSubresource(IStructuredSelection selection) throws CoreException {
        if (!DeleteResourcesAction.containsSourceFolderAsSubresource(selection)) {
            return true;
        }
        String title = ReorgMessages.getString("deleteAction.confirm.title");
        String label = ReorgMessages.getString("DeleteResourcesAction.deleteAction.confirm.message");
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)label);
    }

    private static boolean containsSourceFolderAsSubresource(IStructuredSelection selection) throws CoreException {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IFolder) || !DeleteResourcesAction.containsSourceFolder((IFolder)each)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && DeleteResourcesAction.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(ClipboardActionUtil.canActivate(new DeleteRefactoring(selection.toList(), null)));
        }
    }

    private static boolean confirmDelete(IStructuredSelection selection) throws JavaModelException {
        Assert.isTrue(ClipboardActionUtil.getSelectedProjects(selection).isEmpty());
        String title = ReorgMessages.getString("deleteAction.confirm.title");
        String label = DeleteResourcesAction.createConfirmationString(selection);
        return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)label);
    }

    private static String createConfirmationString(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            String pattern = DeleteResourcesAction.createConfirmationStringForSingleElement(firstElement);
            return MessageFormat.format(pattern, DeleteResourcesAction.getName(firstElement));
        }
        String pattern = DeleteResourcesAction.createConfirmationStringForMultipleElements(selection);
        return MessageFormat.format(pattern, String.valueOf(selection.size()));
    }

    private static String createConfirmationStringForSingleElement(Object firstElement) throws JavaModelException {
        if (DeleteResourcesAction.isDefaultPackageWithLinkedFiles(firstElement)) {
            return ReorgMessages.getString("DeleteResourcesAction.sure_delete_linked_multiple");
        }
        if (!DeleteResourcesAction.isLinkedResource(firstElement)) {
            return ReorgMessages.getString("DeleteResourcesAction.sure_delete");
        }
        if (!DeleteResourcesAction.isLinkedPackageOrPackageFragmentRoot(firstElement)) {
            return ReorgMessages.getString("DeleteResourcesAction.sure_delete_linked_single");
        }
        return ReorgMessages.getString("DeleteResourcesAction.sure_delete_linked_single_package_or_pfr");
    }

    private static String createConfirmationStringForMultipleElements(IStructuredSelection selection) throws JavaModelException {
        if (!DeleteResourcesAction.containsLinkedResources(selection)) {
            return ReorgMessages.getString("DeleteResourcesAction.sure_delete_resources");
        }
        if (!DeleteResourcesAction.containLinkedPackagesOrPackageFragmentRoots(selection)) {
            return ReorgMessages.getString("DeleteResourcesAction.sure_delete_linked_multiple");
        }
        return ReorgMessages.getString("DeleteResourcesAction.sure_delete_linked_multiple_with_packages_or_pfr");
    }

    private static boolean containLinkedPackagesOrPackageFragmentRoots(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (!DeleteResourcesAction.isLinkedPackageOrPackageFragmentRoot(iter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsLinkedResources(IStructuredSelection selection) throws JavaModelException {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (DeleteResourcesAction.isLinkedResource(element)) {
                return true;
            }
            if (!DeleteResourcesAction.isDefaultPackageWithLinkedFiles(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLinkedPackageOrPackageFragmentRoot(Object object) {
        if (object instanceof IPackageFragment || object instanceof IPackageFragmentRoot) {
            return DeleteResourcesAction.isLinkedResource(ResourceUtil.getResource(object));
        }
        return false;
    }

    private static boolean isLinkedResource(Object element) {
        IResource resource = ResourceUtil.getResource(element);
        return resource != null && resource.isLinked();
    }

    private static boolean isDefaultPackageWithLinkedFiles(Object firstElement) throws JavaModelException {
        if (!JavaElementUtil.isDefaultPackage(firstElement)) {
            return false;
        }
        IPackageFragment defaultPackage = (IPackageFragment)firstElement;
        ICompilationUnit[] cus = defaultPackage.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            if (DeleteResourcesAction.isLinkedResource(cus[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getName(Object element) {
        if (JavaElementUtil.isDefaultPackage(element)) {
            return ReorgMessages.getString("DeleteResourcesAction.default_package");
        }
        return ReorgUtils.getName(element);
    }
}

