/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.reorg.CopySourceReferencesToClipboardAction;
import org.eclipse.jdt.internal.ui.reorg.DeleteSourceReferencesAction;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.SourceReferenceAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class CutSourceReferencesToClipboardAction
extends SourceReferenceAction {
    CopySourceReferencesToClipboardAction fCopy;
    DeleteSourceReferencesAction fDelete;

    protected CutSourceReferencesToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction, String helpContextID) {
        super(site);
        this.setText(ReorgMessages.getString("CutSourceReferencesToClipboardAction.cut"));
        this.fCopy = new CopySourceReferencesToClipboardAction(site, clipboard, pasteAction);
        this.fDelete = new DeleteSourceReferencesAction(site);
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)helpContextID);
    }

    protected void perform(IStructuredSelection selection) throws CoreException {
        this.fCopy.perform(selection);
        this.fDelete.perform(selection);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        if (CutSourceReferencesToClipboardAction.containsTopLevelTypes(selection)) {
            this.setEnabled(false);
            return;
        }
        this.fCopy.selectionChanged(selection);
        this.fDelete.selectionChanged(selection);
        this.setEnabled(this.fCopy.isEnabled() && this.fDelete.isEnabled());
    }

    private static boolean containsTopLevelTypes(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IType) || ((IType)each).getDeclaringType() != null) continue;
            return true;
        }
        return false;
    }
}

