/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.SourceReferenceAction;
import org.eclipse.jdt.internal.ui.reorg.TypedSource;
import org.eclipse.jdt.internal.ui.reorg.TypedSourceTransfer;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;

public class CopySourceReferencesToClipboardAction
extends SourceReferenceAction {
    private Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;

    protected CopySourceReferencesToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        Assert.isNotNull(clipboard);
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
    }

    protected void perform(IStructuredSelection selection) throws JavaModelException {
        this.copyToOSClipbard(this.getElementsToProcess(selection));
    }

    private void copyToOSClipbard(ISourceReference[] refs) throws JavaModelException {
        block4: {
            try {
                this.fClipboard.setContents(CopySourceReferencesToClipboardAction.createClipboardInput(refs), CopySourceReferencesToClipboardAction.createTransfers());
                if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
                    this.fPasteAction.update(this.fPasteAction.getSelection());
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)ReorgMessages.getString("CopyToClipboardProblemDialog.title"), (String)ReorgMessages.getString("CopyToClipboardProblemDialog.message"))) break block4;
                this.copyToOSClipbard(refs);
            }
        }
    }

    private static Object[] createClipboardInput(ISourceReference[] refs) throws JavaModelException {
        TypedSource[] typedSources = CopySourceReferencesToClipboardAction.convertToTypedSourceArray(refs);
        return new Object[]{CopySourceReferencesToClipboardAction.convertToInputForTextTransfer(typedSources), typedSources, CopySourceReferencesToClipboardAction.getResourcesForMainTypes(refs)};
    }

    private static Transfer[] createTransfers() {
        return new Transfer[]{TextTransfer.getInstance(), TypedSourceTransfer.getInstance(), ResourceTransfer.getInstance()};
    }

    private static String convertToInputForTextTransfer(TypedSource[] typedSources) throws JavaModelException {
        String lineDelim = System.getProperty("line.separator", "\n");
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < typedSources.length) {
            buff.append(typedSources[i].getSource()).append(lineDelim);
            ++i;
        }
        return buff.toString();
    }

    private static TypedSource[] convertToTypedSourceArray(ISourceReference[] refs) throws JavaModelException {
        TypedSource[] elems = new TypedSource[refs.length];
        int i = 0;
        while (i < refs.length) {
            elems[i] = new TypedSource(refs[i]);
            ++i;
        }
        return elems;
    }

    private static IResource[] getResourcesForMainTypes(ISourceReference[] refs) {
        IType[] mainTypes = CopySourceReferencesToClipboardAction.getMainTypes(refs);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < mainTypes.length) {
            IResource resource = CopySourceReferencesToClipboardAction.getResource(mainTypes[i]);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static IType[] getMainTypes(ISourceReference[] refs) {
        ArrayList<ISourceReference> mainTypes = new ArrayList<ISourceReference>();
        int i = 0;
        while (i < refs.length) {
            try {
                if (refs[i] instanceof IType && JavaElementUtil.isMainType((IType)refs[i])) {
                    mainTypes.add(refs[i]);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        return mainTypes.toArray(new IType[mainTypes.size()]);
    }

    private static IResource getResource(IType type) {
        return ResourceUtil.getResource((IMember)type);
    }
}

