/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.reorg.ClipboardActionUtil;
import org.eclipse.jdt.internal.ui.reorg.JdtCopyAction;
import org.eclipse.jdt.internal.ui.reorg.ReorgActionFactory;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.StructuredSelectionUtil;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyResourcesToClipboardAction
extends SelectionDispatchAction {
    private static final String fgLineDelim = System.getProperty("line.separator");
    private Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;

    protected CopyResourcesToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        Assert.isNotNull(clipboard);
        this.setText(ReorgMessages.getString("CopyResourcesToClipboardAction.copy"));
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(CopyResourcesToClipboardAction.canOperateOn(selection));
    }

    public void run(IStructuredSelection selection) {
        block4: {
            IResource[] resources = this.getSelectedResources(selection);
            try {
                this.fClipboard.setContents(new Object[]{resources, Resources.getLocationOSStrings(resources), CopyResourcesToClipboardAction.getFileNamesText(resources)}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
                    this.fPasteAction.update(this.fPasteAction.getSelection());
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)ReorgMessages.getString("CopyToClipboardProblemDialog.title"), (String)ReorgMessages.getString("CopyToClipboardProblemDialog.message"))) break block4;
                this.run(selection);
            }
        }
    }

    public static boolean canOperateOn(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (StructuredSelectionUtil.hasNonResources(selection)) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IPackageFragment) || !((IPackageFragment)each).isDefaultPackage()) continue;
            return false;
        }
        IResource[] selectedResources = StructuredSelectionUtil.getResources(selection);
        if (selectedResources.length == 0) {
            return false;
        }
        if (!CopyResourcesToClipboardAction.areResourcesOfValidType(selectedResources)) {
            return false;
        }
        if (ClipboardActionUtil.isOneOpenProject(selectedResources)) {
            return true;
        }
        if (!CopyResourcesToClipboardAction.haveCommonParent(selectedResources)) {
            return false;
        }
        JdtCopyAction ca = ReorgActionFactory.createDnDCopyAction(selection.toList(), ClipboardActionUtil.getFirstResource(selection));
        ca.update(ca.getSelection());
        return ca.isEnabled();
    }

    private static boolean areResourcesOfValidType(IResource[] resources) {
        boolean onlyProjectsSelected = ClipboardActionUtil.resourcesAreOfType(resources, 4);
        boolean onlyFilesFoldersSelected = ClipboardActionUtil.resourcesAreOfType(resources, 3);
        if (!onlyFilesFoldersSelected && !onlyProjectsSelected) {
            return false;
        }
        return !onlyFilesFoldersSelected || !onlyProjectsSelected;
    }

    private static boolean haveCommonParent(IResource[] resources) {
        if (CopyResourcesToClipboardAction.haveCommonParentAsResources(resources)) {
            return true;
        }
        if (!ClipboardActionUtil.resourcesAreOfType(resources, 2)) {
            return false;
        }
        IPackageFragment[] packages = CopyResourcesToClipboardAction.getPackages(resources);
        if (packages.length != resources.length) {
            return false;
        }
        IJavaElement firstJavaParent = packages[0].getParent();
        if (firstJavaParent == null) {
            return false;
        }
        int i = 0;
        while (i < packages.length) {
            if (!firstJavaParent.equals(packages[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static IPackageFragment[] getPackages(IResource[] resources) {
        ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IJavaElement element = JavaCore.create((IResource)resources[i]);
            if (element != null && element.getElementType() == 4) {
                packages.add(element);
            }
            ++i;
        }
        return packages.toArray(new IPackageFragment[packages.size()]);
    }

    private static boolean haveCommonParentAsResources(IResource[] resources) {
        IContainer firstParent = resources[0].getParent();
        if (firstParent == null) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (!resources[i].getParent().equals((Object)firstParent)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        return StructuredSelectionUtil.getResources(selection);
    }

    private static String getFileNamesText(IResource[] resources) {
        ILabelProvider labelProvider = CopyResourcesToClipboardAction.getLabelProvider();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < resources.length) {
            if (i > 0) {
                buf.append(fgLineDelim);
            }
            buf.append(CopyResourcesToClipboardAction.getName(resources[i], labelProvider));
            ++i;
        }
        return buf.toString();
    }

    private static ILabelProvider getLabelProvider() {
        return new JavaElementLabelProvider(546);
    }

    private static String getName(IResource resource, ILabelProvider labelProvider) {
        IJavaElement javaElement = JavaCore.create((IResource)resource);
        if (javaElement == null) {
            return labelProvider.getText((Object)resource);
        }
        return labelProvider.getText((Object)javaElement);
    }
}

