/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.reorg.ReorgExceptionHandler;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.StructuredSelectionUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;

class ClipboardActionUtil {
    private ClipboardActionUtil() {
    }

    static boolean resourcesAreOfType(IResource[] resources, int resourceMask) {
        int i = 0;
        while (i < resources.length) {
            if (!ClipboardActionUtil.resourceIsType(resources[i], resourceMask)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    private static boolean isJavaResource(IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        return je != null && je.exists();
    }

    public static IJavaElement[] getJavaElements(IResource[] resources) {
        ArrayList<IJavaElement> jElements = new ArrayList<IJavaElement>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ClipboardActionUtil.isJavaResource(resources[i])) {
                jElements.add(JavaCore.create((IResource)resources[i]));
            }
            ++i;
        }
        return jElements.toArray(new IJavaElement[jElements.size()]);
    }

    public static IResource[] getNonJavaResources(IResource[] resources) {
        ArrayList<IResource> nonJava = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (!ClipboardActionUtil.isJavaResource(resources[i])) {
                nonJava.add(resources[i]);
            }
            ++i;
        }
        return nonJava.toArray(new IResource[nonJava.size()]);
    }

    public static List getConvertedResources(IResource[] resourceData) {
        ArrayList<Object> elems = new ArrayList<Object>(resourceData.length);
        elems.addAll(Arrays.asList(ClipboardActionUtil.getJavaElements(resourceData)));
        elems.addAll(Arrays.asList(ClipboardActionUtil.getNonJavaResources(resourceData)));
        return elems;
    }

    public static IContainer getContainer(IResource selected) {
        if (selected.getType() == 1) {
            return ((IFile)selected).getParent();
        }
        return (IContainer)selected;
    }

    public static IResource getFirstResource(IStructuredSelection selection) {
        return StructuredSelectionUtil.getResources(selection)[0];
    }

    public static Object tryConvertingToJava(IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je == null || !je.exists()) {
            return resource;
        }
        return je;
    }

    public static boolean isOneOpenProject(IResource[] resourceData) {
        return resourceData != null && resourceData.length == 1 && resourceData[0].getType() == 4 && ((IProject)resourceData[0]).isOpen();
    }

    static boolean hasOnlyProjects(IStructuredSelection selection) {
        return !selection.isEmpty() && selection.size() == ClipboardActionUtil.getSelectedProjects(selection).size();
    }

    static List getSelectedProjects(IStructuredSelection selection) {
        ArrayList<Object> result = new ArrayList<Object>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IJavaProject) {
                result.add(((IJavaProject)element).getResource());
                continue;
            }
            if (!(element instanceof IProject)) continue;
            result.add(element);
        }
        return result;
    }

    static boolean canActivate(Refactoring ref) {
        try {
            return ref.checkActivation((IProgressMonitor)new NullProgressMonitor()).isOK();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ReorgMessages.getString("ReorgAction.reorganize"), ReorgMessages.getString("ReorgAction.exception"));
            return false;
        }
    }

    static MultiStatus perform(Refactoring ref) throws JavaModelException {
        PerformChangeOperation op = new PerformChangeOperation(new CreateChangeOperation(ref, 0));
        ReorgExceptionHandler handler = new ReorgExceptionHandler();
        op.setChangeContext(new ChangeContext(handler));
        try {
            new ProgressMonitorDialog(JavaPlugin.getActiveWorkbenchShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof CoreException) {
                handler.getStatus().merge(((CoreException)target).getStatus());
            }
            JavaPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return handler.getStatus();
    }
}

