/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.OrderedMap;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class ExternalizeWizardPage2
extends UserInputWizardPage {
    private static final String SETTING_PROPFILE = "PropertyFile";
    private static final String SETTING_PROPPACK = "PropertyPackage";
    private static final String SETTING_ACCESSORCLASS = "AccessorClass";
    private static final String SETTING_CODEPATTERN = "CodePattern";
    private static final String SETTING_CREATEACCESSOR = "CreateAccessorClass";
    private static final String SETTING_USEDEFAULTPATTERN = "UseDefaultPattern";
    private static final String SETTING_NEWIMPORT = "AddImport";
    private IPackageFragment fPkgFragment;
    public static final String PAGE_NAME = "NLSWizardPage2";
    private StringButtonDialogField fPropertyPackage;
    private StringButtonDialogField fPropertyFile;
    private StringDialogField fAccessorClassName;
    private StringDialogField fCodePattern;
    private StringButtonDialogField fNewImport;
    private SelectionButtonDialogField fUseDefaultPattern;
    private SelectionButtonDialogField fCreateAccessorClass;
    private OrderedMap fErrorMap = new OrderedMap();

    public ExternalizeWizardPage2() {
        super(PAGE_NAME, true);
        this.fPropertyPackage = this.createStringButtonField(NLSUIMessages.getString("wizardPage2.package"), NLSUIMessages.getString("wizardPage2.browse1"), this.createPropertyPackageBrowseAdapter());
        this.fPropertyFile = this.createStringButtonField(NLSUIMessages.getString("wizardPage2.property_file_name"), NLSUIMessages.getString("wizardPage2.browse2"), this.createPropertyFileBrowseAdapter());
        this.fUseDefaultPattern = this.createCheckBoxField(NLSUIMessages.getString("wizardPage2.default_pattern"));
        this.fAccessorClassName = this.createStringField(NLSUIMessages.getString("wizardPage2.class_name"));
        this.fCodePattern = this.createStringField(NLSUIMessages.getString("wizardPage2.code_pattern"));
        this.fCreateAccessorClass = this.createCheckBoxField(NLSUIMessages.getString("wizardPage2.create_accessor"));
        this.fNewImport = this.createStringButtonField(NLSUIMessages.getString("wizardPage2.add_import"), NLSUIMessages.getString("wizardPage2.browse3"), this.createClassBrowseAdapter());
    }

    private StringDialogField createStringField(String label) {
        StringDialogField field = new StringDialogField();
        field.setLabelText(label);
        return field;
    }

    private SelectionButtonDialogField createCheckBoxField(String label) {
        SelectionButtonDialogField field = new SelectionButtonDialogField(32);
        field.setLabelText(label);
        return field;
    }

    private StringButtonDialogField createStringButtonField(String label, String button, IStringButtonAdapter adapter) {
        StringButtonDialogField field = new StringButtonDialogField(adapter);
        field.setLabelText(label);
        field.setButtonLabel(button);
        return field;
    }

    private IStringButtonAdapter createClassBrowseAdapter() {
        return new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ExternalizeWizardPage2.this.browseForClassToImport();
            }
        };
    }

    private IStringButtonAdapter createPropertyPackageBrowseAdapter() {
        return new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ExternalizeWizardPage2.this.browseForPropertyPackage();
            }
        };
    }

    private IStringButtonAdapter createPropertyFileBrowseAdapter() {
        return new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ExternalizeWizardPage2.this.browseForPropertyFile();
            }
        };
    }

    private void initializeDialogField(SelectionButtonDialogField field, String property, boolean def) {
        String s = JavaPlugin.getDefault().getDialogSettings().get(property);
        if (s != null) {
            field.setSelection(new Boolean(s));
        } else {
            field.setSelection(def);
        }
    }

    private void initializeDialogField(StringDialogField field, String property, String def) {
        String s = JavaPlugin.getDefault().getDialogSettings().get(property);
        if (s != null) {
            field.setText(s);
        } else {
            field.setText(def);
        }
    }

    private void initializeFields() {
        this.initializeDialogField(this.fPropertyFile, SETTING_PROPFILE, this.getNLSRefactoring().getDefaultPropertyFileName());
        this.initializeDialogField(this.fPropertyPackage, SETTING_PROPPACK, this.getNLSRefactoring().getDefaultPropertyPackageName());
        this.initializeDialogField(this.fCodePattern, SETTING_CODEPATTERN, this.getNLSRefactoring().getCodePattern());
        this.initializeDialogField(this.fAccessorClassName, SETTING_ACCESSORCLASS, this.getNLSRefactoring().getAccessorClassName());
        this.initializeDialogField(this.fUseDefaultPattern, SETTING_USEDEFAULTPATTERN, true);
        this.initializeDialogField(this.fNewImport, SETTING_NEWIMPORT, "");
        this.initializeDialogField(this.fCreateAccessorClass, SETTING_CREATEACCESSOR, this.getNLSRefactoring().getCreateAccessorClass());
        this.updateEnabledStates();
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        Separator label = new Separator(0);
        ((Label)label.getSeparator(parent)).setText(NLSUIMessages.getString("wizardPage2.property_location"));
        label.doFillIntoGrid(parent, 3, 20);
        this.fPropertyPackage.doFillIntoGrid(parent, 3);
        this.fPropertyPackage.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.validatePropertyPackage();
            }
        });
        LayoutUtil.setHorizontalGrabbing((Control)this.fPropertyPackage.getTextControl(null));
        this.fPropertyFile.doFillIntoGrid(parent, 3);
        this.fPropertyFile.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.validatePropertyFilename();
            }
        });
        Separator s = new Separator(258);
        s.doFillIntoGrid(parent, 3);
        this.fCreateAccessorClass.setLabelText(String.valueOf(NLSUIMessages.getString("wizardPage2.create_accessor")) + "\"" + ExternalizeWizardPage2.getPackageName(this.getCu()) + "\"" + NLSUIMessages.getString("wizardPage2.if_needed"));
        this.fCreateAccessorClass.doFillIntoGrid(parent, 3);
        this.fCreateAccessorClass.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.toggleAccessorClassCreation();
                ExternalizeWizardPage2.this.updateEnabledStates();
            }
        });
        this.fAccessorClassName.doFillIntoGrid(parent, 3);
        this.fAccessorClassName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.validateAccessorClassName();
            }
        });
        this.fUseDefaultPattern.doFillIntoGrid(parent, 3);
        this.fUseDefaultPattern.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.toggleUseDefaultPattern();
                ExternalizeWizardPage2.this.updateEnabledStates();
            }
        });
        this.fCodePattern.doFillIntoGrid(parent, 3);
        this.fNewImport.doFillIntoGrid(parent, 3);
        this.fNewImport.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalizeWizardPage2.this.validateNewImport();
            }
        });
        this.setControl((Control)parent);
        this.initializeFields();
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.jdt.ui.externalize_wizard_properties_file_page_context");
    }

    private static String getPackageName(ICompilationUnit cu) {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        if (pack.isDefaultPackage()) {
            return NLSUIMessages.getString("wizardPage2.default_package");
        }
        return pack.getElementName();
    }

    private void validateNewImport() {
        String importName = this.fNewImport.getText();
        if (importName == null || "".equals(importName.trim())) {
            this.setValid(this.fNewImport);
            return;
        }
        IStatus status = JavaConventions.validateImportDeclaration((String)importName);
        if (status.getSeverity() == 4) {
            this.setInvalid(this.fNewImport, status.getMessage());
            return;
        }
        this.setValid(this.fNewImport);
    }

    private void validateAccessorClassName() {
        String className = this.fAccessorClassName.getText();
        this.getNLSRefactoring().setAccessorClassName(className);
        if (this.fUseDefaultPattern.isSelected()) {
            this.getNLSRefactoring().setCodePattern(this.getNLSRefactoring().getDefaultCodePattern());
            this.fCodePattern.setText(this.getNLSRefactoring().getCodePattern());
        } else {
            this.getNLSRefactoring().setCodePattern(this.fCodePattern.getText());
        }
        IStatus status = JavaConventions.validateJavaTypeName((String)className);
        if (status.getSeverity() == 4) {
            this.setInvalid(this.fAccessorClassName, status.getMessage());
            return;
        }
        if (className.indexOf(".") != -1) {
            this.setInvalid(this.fAccessorClassName, NLSUIMessages.getString("wizardPage2.no_dot"));
            return;
        }
        this.setValid(this.fAccessorClassName);
    }

    private void updateEnabledStates() {
        this.fAccessorClassName.setEnabled(this.fCreateAccessorClass.isSelected());
        this.fCodePattern.setEnabled(!this.fUseDefaultPattern.isSelected());
        this.fNewImport.setEnabled(!this.fUseDefaultPattern.isSelected());
        this.fCreateAccessorClass.setEnabled(this.fUseDefaultPattern.isSelected());
    }

    private void toggleAccessorClassCreation() {
        this.getNLSRefactoring().setCreateAccessorClass(this.fCreateAccessorClass.isSelected());
    }

    private void toggleUseDefaultPattern() {
        this.fCreateAccessorClass.setSelection(this.fUseDefaultPattern.isSelected());
        if (this.fUseDefaultPattern.isSelected()) {
            this.getNLSRefactoring().setCodePattern(this.getNLSRefactoring().getDefaultCodePattern());
            this.fCodePattern.setText(this.getNLSRefactoring().getCodePattern());
            this.fNewImport.setText("");
        }
    }

    private void browseForClassToImport() {
        IType type;
        IPackageFragmentRoot root = ExternalizeWizardPage2.getPackageFragmentRoot(this.getCu());
        if (root == null) {
            return;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root.getJavaProject()});
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
        dialog.setTitle(NLSUIMessages.getString("wizardPage2.Class_Selection"));
        dialog.setMessage(NLSUIMessages.getString("wizardPage2.Choose_the_type_to_import"));
        dialog.setUpperListLabel(NLSUIMessages.getString("wizardPage2.Matching_classes"));
        String guessTypeName = this.fNewImport.getText().substring(this.fNewImport.getText().lastIndexOf(".") + 1);
        dialog.setFilter(guessTypeName);
        if (dialog.open() == 0 && (type = (IType)dialog.getFirstResult()) != null) {
            this.fNewImport.setText(JavaModelUtil.getFullyQualifiedName(type));
        }
    }

    private void browseForPropertyFile() {
        IFile selectedFile;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), ExternalizeWizardPage2.getLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle(NLSUIMessages.getString("wizardPage2.Property_File_Selection"));
        dialog.setMessage(NLSUIMessages.getString("wizardPage2.Choose_the_property_file"));
        dialog.setElements(this.createFileListInput());
        dialog.setFilter("*.properties");
        if (dialog.open() == 0 && (selectedFile = (IFile)dialog.getFirstResult()) != null) {
            this.fPropertyFile.setText(selectedFile.getName());
        }
    }

    private void browseForPropertyPackage() {
        IPackageFragment selectedPackage;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), ExternalizeWizardPage2.getLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle(NLSUIMessages.getString("wizardPage2.package_selection"));
        dialog.setMessage(NLSUIMessages.getString("wizardPage2.choose_package"));
        dialog.setElements(this.createPackageListInput());
        dialog.setFilter("");
        if (dialog.open() == 0 && (selectedPackage = (IPackageFragment)dialog.getFirstResult()) != null) {
            this.fPropertyPackage.setText(selectedPackage.getElementName());
        }
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(ICompilationUnit cu) {
        return (IPackageFragmentRoot)cu.getParent().getParent();
    }

    private ICompilationUnit getCu() {
        return this.getNLSRefactoring().getCu();
    }

    private Object[] createFileListInput() {
        try {
            if (this.fPkgFragment == null) {
                return new Object[0];
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            Object[] nonjava = this.fPkgFragment.getNonJavaResources();
            int i = 0;
            while (i < nonjava.length) {
                if (ExternalizeWizardPage2.isPropertyFile(nonjava[i])) {
                    result.add(nonjava[i]);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSUIMessages.getString("wizardPage2.externalizing"), NLSUIMessages.getString("wizardPage2.exception"));
            return new Object[0];
        }
    }

    private static boolean isPropertyFile(Object o) {
        if (!(o instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)o;
        return ".properties".equals("." + file.getFileExtension());
    }

    private Object[] createPackageListInput() {
        try {
            IJavaProject project = this.getCu().getJavaProject();
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < roots.length) {
                if (ExternalizeWizardPage2.canAddPackageRoot(roots[i])) {
                    result.addAll(this.getValidPackages(roots[i]));
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSUIMessages.getString("wizardPage2.externalizing"), NLSUIMessages.getString("wizardPage2.exception"));
            return new Object[0];
        }
    }

    private List getValidPackages(IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] children = null;
        try {
            children = root.getChildren();
        }
        catch (JavaModelException javaModelException) {
            return new ArrayList(0);
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(children.length);
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IPackageFragment && ExternalizeWizardPage2.canAddPackage((IPackageFragment)children[i])) {
                result.add(children[i]);
            }
            ++i;
        }
        return result;
    }

    private static boolean canAddPackageRoot(IPackageFragmentRoot root) throws JavaModelException {
        if (!root.exists()) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (root.isReadOnly()) {
            return false;
        }
        return root.isStructureKnown();
    }

    private static boolean canAddPackage(IPackageFragment p) throws JavaModelException {
        if (!p.exists()) {
            return false;
        }
        if (p.isReadOnly()) {
            return false;
        }
        if (!p.isStructureKnown()) {
            return false;
        }
        return p.containsJavaResources() || p.getNonJavaResources().length != 0;
    }

    private static ILabelProvider getLabelProvider() {
        return new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    }

    private void validatePropertyPackage() {
        String pkgName = this.fPropertyPackage.getText();
        IStatus status = JavaConventions.validatePackageName((String)pkgName);
        if (!"".equals(pkgName) && status.getSeverity() == 4) {
            this.setInvalid(this.fPropertyPackage, status.getMessage());
            return;
        }
        IPath pkgPath = new Path(pkgName.replace('.', '/')).makeRelative();
        IJavaProject project = this.getCu().getJavaProject();
        try {
            IJavaElement element = project.findElement(pkgPath);
            if (element == null || !element.exists()) {
                this.setInvalid(this.fPropertyPackage, NLSUIMessages.getString("wizardPage2.must_exist"));
                return;
            }
            this.fPkgFragment = (IPackageFragment)element;
            if (!ExternalizeWizardPage2.canAddPackage(this.fPkgFragment)) {
                this.setInvalid(this.fPropertyPackage, NLSUIMessages.getString("wizardPage2.incorrect_package"));
                return;
            }
            if (!ExternalizeWizardPage2.canAddPackageRoot((IPackageFragmentRoot)this.fPkgFragment.getParent())) {
                this.setInvalid(this.fPropertyPackage, NLSUIMessages.getString("wizardPage2.incorrect_package"));
                return;
            }
        }
        catch (JavaModelException e) {
            this.setInvalid(this.fPropertyPackage, e.getStatus().getMessage());
            return;
        }
        this.setValid(this.fPropertyPackage);
    }

    private void validatePropertyFilename() {
        String fileName = this.fPropertyFile.getText();
        if (fileName == null || "".equals(fileName)) {
            this.setInvalid(this.fPropertyFile, NLSUIMessages.getString("wizardPage2.enter_name"));
            return;
        }
        if (!fileName.endsWith(".properties")) {
            this.setInvalid(this.fPropertyFile, String.valueOf(NLSUIMessages.getString("wizardPage2.file_name_must_end")) + ".properties" + "\".");
            return;
        }
        this.setValid(this.fPropertyFile);
    }

    private void setInvalid(Object field, String msg) {
        this.fErrorMap.push(field, msg);
        this.updateErrorMessage();
    }

    private void setValid(Object field) {
        this.fErrorMap.remove(field);
        this.updateErrorMessage();
    }

    private void updateErrorMessage() {
        String msg = (String)this.fErrorMap.peek();
        this.setPageComplete(msg == null);
        this.setErrorMessage(msg);
    }

    private NLSRefactoring getNLSRefactoring() {
        return (NLSRefactoring)this.getRefactoring();
    }

    public boolean performFinish() {
        this.updateRefactoring();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.updateRefactoring();
        return super.getNextPage();
    }

    public void dispose() {
        this.fCodePattern = null;
        this.fErrorMap = null;
        this.fPkgFragment = null;
        this.fPropertyFile = null;
        this.fPropertyPackage = null;
        this.fUseDefaultPattern = null;
        this.fNewImport = null;
        this.fAccessorClassName = null;
        this.fCreateAccessorClass = null;
        super.dispose();
    }

    private void storeDialogSettings() {
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_PROPFILE, this.fPropertyFile.getText());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_PROPPACK, this.fPropertyPackage.getText());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_ACCESSORCLASS, this.fAccessorClassName.getText());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_CODEPATTERN, this.fCodePattern.getText());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_CREATEACCESSOR, this.fCreateAccessorClass.isSelected());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_USEDEFAULTPATTERN, this.fUseDefaultPattern.isSelected());
        JavaPlugin.getDefault().getDialogSettings().put(SETTING_NEWIMPORT, this.fNewImport.getText());
    }

    void updateRefactoring() {
        this.storeDialogSettings();
        this.getNLSRefactoring().setPropertyFilePath(this.fPkgFragment.getPath().append(this.fPropertyFile.getText()));
        this.getNLSRefactoring().setCodePattern(this.fCodePattern.getText());
        this.getNLSRefactoring().setAddedImportDeclaration(this.fNewImport.getText());
        this.getNLSRefactoring().setCreateAccessorClass(this.fCreateAccessorClass.isSelected());
    }
}

