/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.code;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractMethodInputPage";
    private ExtractMethodRefactoring fRefactoring;
    private Text fTextField;
    private boolean fFirstTime;
    private Label fPreview;
    private IDialogSettings fSettings;
    private static final String DESCRIPTION = RefactoringMessages.getString("ExtractMethodInputPage.description");
    private static final String THROW_RUNTIME_EXCEPTIONS = "ThrowRuntimeExceptions";

    public ExtractMethodInputPage() {
        super(PAGE_NAME, true);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
        this.fFirstTime = true;
    }

    public void createControl(Composite parent) {
        this.fRefactoring = (ExtractMethodRefactoring)this.getRefactoring();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        GridData gd = null;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(this.getLabelText());
        this.fTextField = this.createTextInputField(result, 2048);
        this.fTextField.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label, (Control)this.fTextField, 1);
        label = new Label(result, 0);
        label.setText(RefactoringMessages.getString("ExtractMethodInputPage.access_Modifiers"));
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{RefactoringMessages.getString("ExtractMethodInputPage.public"), RefactoringMessages.getString("ExtractMethodInputPage.protected"), RefactoringMessages.getString("ExtractMethodInputPage.default"), RefactoringMessages.getString("ExtractMethodInputPage.private")};
        String[] data = new String[]{"public", "protected", "", "private"};
        String visibility = this.fRefactoring.getVisibility();
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button(group, 16);
            radio.setText(labels[i]);
            radio.setData((Object)data[i]);
            if (data[i].equals(visibility)) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExtractMethodInputPage.this.setVisibility((String)event.widget.getData());
                }
            });
            ++i;
        }
        layouter.perform((Control)label, (Control)group, 1);
        if (!this.fRefactoring.getParameterInfos().isEmpty()) {
            ChangeParametersControl cp = new ChangeParametersControl(result, 0, RefactoringMessages.getString("ExtractMethodInputPage.parameters"), new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.parameterModified(parameter);
                }

                public void parameterListChanged() {
                    ExtractMethodInputPage.this.updatePreview(ExtractMethodInputPage.this.getText());
                }

                public void parameterAdded(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.updatePreview(ExtractMethodInputPage.this.getText());
                }
            }, true, false, false);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            cp.setLayoutData(gd);
            cp.setInput(this.fRefactoring.getParameterInfos());
        }
        Button checkBox = new Button(result, 32);
        checkBox.setText(RefactoringMessages.getString("ExtractMethodInputPage.throwRuntimeExceptions"));
        checkBox.setSelection(this.fSettings.getBoolean(THROW_RUNTIME_EXCEPTIONS));
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractMethodInputPage.this.setRethrowRuntimeException(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        label = new Label(result, 258);
        label.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label);
        label = new Label(result, 0);
        gd = new GridData();
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        label.setText(RefactoringMessages.getString("ExtractMethodInputPage.signature_preview"));
        this.fPreview = new Label(result, 64);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPreview.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)this.fPreview, 1);
        Dialog.applyDialogFont((Control)result);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.extract_method_wizard_page_context");
    }

    private Text createTextInputField(Composite parent, int style) {
        Text result = new Text(parent, style);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractMethodInputPage.this.textModified(ExtractMethodInputPage.this.getText());
            }
        });
        return result;
    }

    private String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    private String getLabelText() {
        return RefactoringMessages.getString("ExtractMethodInputPage.label_text");
    }

    private void setVisibility(String s) {
        this.fRefactoring.setVisibility(s);
        this.updatePreview(this.getText());
    }

    private void setRethrowRuntimeException(boolean value) {
        this.fSettings.put(THROW_RUNTIME_EXCEPTIONS, value);
        this.fRefactoring.setThrowRuntimeExceptions(value);
        this.updatePreview(this.getText());
    }

    private void updatePreview(String text) {
        if (this.fPreview == null) {
            return;
        }
        if (text.length() == 0) {
            text = "someMethodName";
        }
        this.fPreview.setText(this.fRefactoring.getSignature(text));
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("ExtractMethodWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("ExtractMethodWizard");
            this.fSettings.put(THROW_RUNTIME_EXCEPTIONS, false);
        }
        this.fRefactoring.setThrowRuntimeExceptions(this.fSettings.getBoolean(THROW_RUNTIME_EXCEPTIONS));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.fTextField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(visible);
    }

    private void textModified(String text) {
        this.fRefactoring.setMethodName(text);
        this.updatePreview(text);
        this.setPageComplete(this.validatePage(true));
    }

    private void parameterModified(ParameterInfo parameter) {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String text = this.getText();
        if ("".equals(text)) {
            result.addFatalError(RefactoringMessages.getString("ExtractMethodInputPage.validation.emptyMethodName"));
            return result;
        }
        result.merge(this.fRefactoring.checkMethodName());
        return result;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        List parameters = this.fRefactoring.getParameterInfos();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!"".equals(info.getNewName())) continue;
            result.addFatalError(RefactoringMessages.getString("ExtractMethodInputPage.validation.emptyParameterName"));
            return result;
        }
        result.merge(this.fRefactoring.checkParameterNames());
        return result;
    }
}

