/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.changes.AbortChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

abstract class UndoManagerAction
implements IWorkbenchWindowActionDelegate {
    private static final int MAX_LENGTH = 30;
    private RefactoringStatus fPreflightStatus;
    private IAction fAction;
    private IWorkbenchWindow fWorkbenchWindow;
    private UndoManagerAdapter fUndoManagerListener;

    protected abstract IRunnableWithProgress createOperation(ChangeContext var1);

    protected abstract UndoManagerAdapter createUndoManagerListener();

    protected abstract String getName();

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected boolean isHooked() {
        return this.fAction != null;
    }

    protected void hookListener(IAction action) {
        if (this.isHooked()) {
            return;
        }
        this.fAction = action;
        this.fUndoManagerListener = this.createUndoManagerListener();
        Refactoring.getUndoManager().addListener(this.fUndoManagerListener);
    }

    protected String shortenText(String text, int patternLength) {
        int length = text.length();
        int finalLength = 30 + patternLength;
        if (text.length() <= finalLength) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int mid = finalLength / 2;
        result.append(text.substring(0, mid));
        result.append("...");
        result.append(text.substring(length - mid));
        return result.toString();
    }

    public void dispose() {
        if (this.fUndoManagerListener != null) {
            Refactoring.getUndoManager().removeListener(this.fUndoManagerListener);
        }
        this.fWorkbenchWindow = null;
        this.fAction = null;
        this.fUndoManagerListener = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void run(IAction action) {
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        ChangeContext context = new ChangeContext(new AbortChangeExceptionHandler(), this.getUnsavedFiles());
        IRunnableWithProgress op = this.createOperation(context);
        try {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, op);
            }
            catch (InvocationTargetException e) {
                Refactoring.getUndoManager().flush();
                ExceptionHandler.handle(e, RefactoringMessages.getString("UndoManagerAction.error"), RefactoringMessages.getString("UndoManagerAction.internal_error"));
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            context.clearPerformedChanges();
            throw throwable;
        }
        Object var6_10 = null;
        context.clearPerformedChanges();
        if (this.fPreflightStatus != null && this.fPreflightStatus.hasError()) {
            String name = this.getName();
            MultiStatus status = this.createMultiStatus(name);
            String message = RefactoringMessages.getFormattedString("UndoManagerAction.cannot_be_executed", name);
            ErrorDialog error = new ErrorDialog(parent, name, message, (IStatus)status, 4){

                public void create() {
                    super.create();
                    this.buttonPressed(13);
                }
            };
            error.open();
        }
        this.fPreflightStatus = null;
    }

    void setPreflightStatus(RefactoringStatus status) {
        this.fPreflightStatus = status;
    }

    private MultiStatus createMultiStatus(String name) {
        MultiStatus status = new MultiStatus(JavaPlugin.getPluginId(), 4, RefactoringMessages.getString("UndoManagerAction.unsaved_filed"), null);
        String id = JavaPlugin.getPluginId();
        Iterator iter = this.fPreflightStatus.getEntries().iterator();
        while (iter.hasNext()) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)iter.next();
            status.merge((IStatus)new Status(4, id, 4, entry.getMessage(), null));
        }
        return status;
    }

    private IFile[] getUnsavedFiles() {
        IEditorPart[] parts = JavaPlugin.getDirtyEditors();
        ArrayList<IFile> result = new ArrayList<IFile>(parts.length);
        int i = 0;
        while (i < parts.length) {
            IEditorInput input = parts[i].getEditorInput();
            if (input instanceof IFileEditorInput) {
                result.add(((IFileEditorInput)input).getFile());
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public abstract void selectionChanged(IAction var1, ISelection var2);
}

