/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RenameRefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;

public class RenameTempAction
extends SelectionDispatchAction {
    private final CompilationUnitEditor fEditor;
    private final String fDialogMessageTitle;

    public RenameTempAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("RenameTempAction.rename_Local_Variable"));
        this.fEditor = editor;
        this.fDialogMessageTitle = RefactoringMessages.getString("RenameTempAction.rename_Local_Variable");
        this.setEnabled(this.fEditor != null && this.getCompilationUnit() != null);
    }

    protected Refactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return new RenameTempRefactoring(cunit, selection.getOffset(), selection.getLength());
    }

    protected RefactoringWizard createWizard(Refactoring refactoring) {
        String message = RefactoringMessages.getString("RenameTempAction.choose_new_name");
        String wizardPageHelp = "org.eclipse.jdt.ui.rename_local_variable_wizard_page_context";
        String errorPageHelp = "org.eclipse.jdt.ui.rename_local_variable_error_wizard_page_context";
        return new RenameRefactoringWizard((RenameTempRefactoring)refactoring, this.getText(), message, wizardPageHelp, errorPageHelp);
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    public boolean canRun(ITextSelection selection) {
        this.selectionChanged(selection);
        if (!this.isEnabled()) {
            return false;
        }
        if (this.getCompilationUnit() == null) {
            return false;
        }
        Refactoring renameTempRefactoring = this.createRefactoring(this.getCompilationUnit(), selection);
        try {
            return renameTempRefactoring.checkActivation((IProgressMonitor)new NullProgressMonitor()).isOK();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("RenameTempAction.rename_Local_Variable"), RefactoringMessages.getString("RenameTempAction.exception"));
            return false;
        }
    }

    protected void run(ITextSelection selection) {
        try {
            ICompilationUnit input = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            Refactoring refactoring = this.createRefactoring(input, selection);
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), this.fDialogMessageTitle, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.fDialogMessageTitle, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private ICompilationUnit getCompilationUnit() {
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }
}

