/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSupport;
import org.eclipse.jdt.internal.ui.reorg.IRefactoringRenameSupport;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(IWorkbenchSite site) {
        super(site);
    }

    public void run(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            return;
        }
        this.run(element);
    }

    private void run(IResource element) {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        RefactoringSupport.Resource support = new RefactoringSupport.Resource(element);
        if (!RenameResourceAction.canRename(support, element)) {
            return;
        }
        try {
            support.rename(this.getShell(), element);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("RenameJavaElementAction.name"), RefactoringMessages.getString("RenameJavaElementAction.exception"));
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(RenameResourceAction.canRename(element));
        }
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }

    private static boolean canRename(IResource element) {
        return RenameResourceAction.canRename(new RefactoringSupport.Resource(element), element);
    }

    private static boolean canRename(IRefactoringRenameSupport support, IResource element) {
        if (support == null) {
            return false;
        }
        try {
            return support.canRename(element);
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }
}

