/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class RenameInputDialog
extends InputDialog {
    private final IRenameRefactoring fRefactoring;

    public RenameInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, IRenameRefactoring refactoring) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        Assert.isNotNull(refactoring);
        this.fRefactoring = refactoring;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (!(this.fRefactoring instanceof IReferenceUpdatingRefactoring)) {
            return composite;
        }
        final IReferenceUpdatingRefactoring ref = (IReferenceUpdatingRefactoring)((Object)this.fRefactoring);
        if (!ref.canEnableUpdateReferences()) {
            return composite;
        }
        final Button checkBox = new Button(composite, 32);
        checkBox.setLayoutData((Object)new GridData(768));
        checkBox.setText(RefactoringMessages.getString("RenameInputDialog.update_references"));
        checkBox.setSelection(ref.getUpdateReferences());
        ref.setUpdateReferences(checkBox.getSelection());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(checkBox.getSelection());
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

