/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformRefactoringUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardDialog2;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringErrorDialogUtil;
import org.eclipse.jdt.internal.ui.refactoring.actions.RenameInputDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStarter {
    private RefactoringSaveHelper fSaveHelper = new RefactoringSaveHelper();

    public Object activate(Refactoring refactoring, RefactoringWizard wizard, Shell parent, String dialogTitle, boolean mustSaveEditors) throws JavaModelException {
        if (!this.canActivate(mustSaveEditors)) {
            return null;
        }
        RefactoringStatus activationStatus = this.checkActivation(refactoring, dialogTitle);
        if (activationStatus.hasFatalError()) {
            return RefactoringErrorDialogUtil.open(dialogTitle, activationStatus);
        }
        wizard.setActivationStatus(activationStatus);
        Object dialog = wizard.hasMultiPageUserInput() ? new RefactoringWizardDialog(parent, wizard) : new RefactoringWizardDialog2(parent, wizard);
        if (dialog.open() == 1) {
            this.fSaveHelper.triggerBuild();
        }
        return null;
    }

    public Object activate(final IRenameRefactoring renameRefactoring, Shell parent, String dialogTitle, String dialogMessage, boolean mustSaveEditors, Object element) throws JavaModelException {
        if (!this.canActivate(mustSaveEditors)) {
            return null;
        }
        if (!this.checkReadOnly(element)) {
            return null;
        }
        Refactoring refactoring = (Refactoring)((Object)renameRefactoring);
        RefactoringStatus activationStatus = this.checkActivation(refactoring, dialogTitle);
        if (activationStatus.hasFatalError()) {
            return RefactoringErrorDialogUtil.open(dialogTitle, activationStatus);
        }
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                try {
                    RefactoringStatus check = renameRefactoring.checkNewName(newText);
                    if (check.isOK()) {
                        return null;
                    }
                    return check.getFirstMessage(1);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return RefactoringMessages.getString("RefactoringStarter.unexpected_exception");
                }
            }
        };
        RenameInputDialog dialog = new RenameInputDialog(parent, dialogTitle, dialogMessage, renameRefactoring.getCurrentName(), validator, renameRefactoring);
        int result = dialog.open();
        if (result != 0) {
            this.fSaveHelper.triggerBuild();
            return null;
        }
        renameRefactoring.setNewName(dialog.getValue());
        PerformChangeOperation pco = new PerformChangeOperation(new CreateChangeOperation(refactoring, 6));
        ProgressMonitorDialog context = new ProgressMonitorDialog(JavaPlugin.getActiveWorkbenchShell());
        PerformRefactoringUtil.performRefactoring(pco, refactoring, (IRunnableContext)context, parent);
        return null;
    }

    private RefactoringStatus checkActivation(Refactoring refactoring, String errorDialogTitle) {
        try {
            CheckConditionsOperation cco = new CheckConditionsOperation(refactoring, 2);
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            context.run(false, false, cco);
            return cco.getStatus();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, "Error", RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    private boolean checkReadOnly(Object element) throws JavaModelException {
        if (this.isReadOnly(element)) {
            return MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)RefactoringMessages.getString("RefactoringStarter.rename"), (String)RefactoringMessages.getFormattedString("RefactoringStarter.is_read_only", ReorgUtils.getName(element)));
        }
        return true;
    }

    private boolean isReadOnly(Object element) throws JavaModelException {
        if (element instanceof IResource) {
            return ((IResource)element).isReadOnly();
        }
        if (element instanceof IJavaProject) {
            return ((IJavaProject)element).getProject().isReadOnly();
        }
        if (element instanceof IPackageFragmentRoot) {
            return this.isReadOnly((IPackageFragmentRoot)element);
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean isReadOnly(IPackageFragmentRoot root) throws JavaModelException {
        if (Checks.isClasspathDelete(root)) {
            return false;
        }
        return root.getResource().isReadOnly();
    }

    private boolean canActivate(boolean mustSaveEditors) {
        return !mustSaveEditors || this.fSaveHelper.saveEditors();
    }
}

