/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringStatusContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringStatusEntryLabelProvider;
import org.eclipse.jdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

public class RefactoringErrorDialogUtil {
    private RefactoringErrorDialogUtil() {
    }

    public static Object open(String dialogTitle, RefactoringStatus status) {
        if (status.getEntries().size() == 1) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)status.getEntries().get(0);
            String message = status.getFirstMessage(4);
            if (entry.getCode() != 1 && entry.getCode() != 2) {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)dialogTitle, (String)message);
                return null;
            }
            message = String.valueOf(message) + RefactoringMessages.getString("RefactoringErrorDialogUtil.okToPerformQuestion");
            if (MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)dialogTitle, (String)message)) {
                return entry.getData();
            }
            return null;
        }
        RefactoringErrorDialogUtil.openListDialog(dialogTitle, status);
        return null;
    }

    private static void openListDialog(String dialogTitle, RefactoringStatus status) {
        ListDialog dialog = new ListDialog(JavaPlugin.getActiveWorkbenchShell());
        dialog.setInput(status);
        dialog.setTitle(dialogTitle);
        dialog.setMessage(RefactoringMessages.getString("RefactoringErrorDialogUtil.cannot_perform"));
        dialog.setContentProvider(new RefactoringStatusContentProvider());
        dialog.setLabelProvider((ILabelProvider)new RefactoringStatusEntryLabelProvider());
        dialog.open();
    }
}

