/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.MoveInstanceMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveInstanceMethodAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = RefactoringMessages.getString("MoveInstanceMethodAction.dialog_title");

    public MoveInstanceMethodAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public MoveInstanceMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("MoveInstanceMethodAction.Move_Method"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    protected void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IMethod && this.shouldAcceptElement((IMethod)first);
    }

    private boolean shouldAcceptElement(IMethod method) throws JavaModelException {
        return !method.isBinary() && !JdtFlags.isStatic((IMember)method);
    }

    protected void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(this.canEnable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue(first instanceof IMethod);
            IMethod method = (IMethod)first;
            this.run(method.getNameRange().getOffset(), method.getNameRange().getLength(), method.getCompilationUnit());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("MoveInstanceMethodAction.unexpected_exception"));
        }
    }

    protected void run(ITextSelection selection) {
        this.run(selection.getOffset(), selection.getLength(), this.getCompilationUnitForTextSelection());
    }

    private void run(int selectionOffset, int selectionLength, ICompilationUnit cu) {
        Assert.isNotNull(cu);
        Assert.isTrue(selectionOffset >= 0);
        Assert.isTrue(selectionLength >= 0);
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        MoveInstanceMethodRefactoring refactoring = MoveInstanceMethodRefactoring.create(cu, selectionOffset, selectionLength, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)RefactoringMessages.getString("MoveInstanceMethodAction.No_reference_or_declaration"));
            return;
        }
        try {
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_TITLE, true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("MoveInstanceMethodAction.unexpected_exception"));
        }
    }

    private ICompilationUnit getCompilationUnitForTextSelection() {
        Assert.isNotNull(this.fEditor);
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    private RefactoringWizard createWizard(MoveInstanceMethodRefactoring refactoring) {
        return new MoveInstanceMethodWizard(refactoring);
    }
}

