/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.InlineConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class InlineConstantAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = RefactoringMessages.getString("InlineConstantAction.dialog_title");

    public InlineConstantAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineConstantAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("InlineConstantAction.inline_Constant"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
    }

    protected void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    protected void selectionChanged(ITextSelection selection) {
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IField && this.shouldAcceptElement((IField)first);
    }

    private boolean shouldAcceptElement(IField field) throws JavaModelException {
        return !field.isBinary() && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field);
    }

    protected void run(IStructuredSelection selection) {
        try {
            Assert.isTrue(this.canEnable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue(first instanceof IField);
            IField field = (IField)first;
            this.run(field.getNameRange().getOffset(), field.getNameRange().getLength(), field.getCompilationUnit());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("InlineConstantAction.unexpected_exception"));
        }
    }

    protected void run(ITextSelection selection) {
        this.run(selection.getOffset(), selection.getLength(), this.getCompilationUnitForTextSelection());
    }

    private void run(int selectionOffset, int selectionLength, ICompilationUnit cu) {
        Assert.isNotNull(cu);
        Assert.isTrue(selectionOffset >= 0);
        Assert.isTrue(selectionLength >= 0);
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        InlineConstantRefactoring refactoring = InlineConstantRefactoring.create(cu, selectionOffset, selectionLength, JavaPreferencesSettings.getCodeGenerationSettings());
        if (refactoring == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)RefactoringMessages.getString("InlineConstantAction.no_constant_reference_or_declaration"));
            return;
        }
        try {
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_TITLE, true);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), DIALOG_TITLE, RefactoringMessages.getString("InlineConstantAction.unexpected_exception"));
        }
    }

    private ICompilationUnit getCompilationUnitForTextSelection() {
        Assert.isNotNull(this.fEditor);
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }

    private RefactoringWizard createWizard(InlineConstantRefactoring refactoring) {
        return new InlineConstantWizard(refactoring);
    }
}

