/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSupertypeWherePossibleRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class UseSupertypeInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "UseSupertypeInputPage";
    private TableViewer fTableViewer;
    private final Map fFileCount = new HashMap(2);
    private static final String MESSAGE = RefactoringMessages.getString("UseSupertypeInputPage.Select_supertype");
    private JavaElementLabelProvider fTableLabelProvider;

    public UseSupertypeInputPage() {
        super(PAGE_NAME, true);
        this.setMessage(MESSAGE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        final Button checkbox = new Button(composite, 32);
        checkbox.setText(RefactoringMessages.getString("UseSupertypeInputPage.Use_in_instanceof"));
        checkbox.setLayoutData((Object)new GridData());
        checkbox.setSelection(this.getUseSupertypeRefactoring().getUseSupertypeInInstanceOf());
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UseSupertypeInputPage.this.getUseSupertypeRefactoring().setUseSupertypeInInstanceOf(checkbox.getSelection());
                UseSupertypeInputPage.this.setMessage(MESSAGE);
                UseSupertypeInputPage.this.setPageComplete(true);
                UseSupertypeInputPage.this.fFileCount.clear();
                UseSupertypeInputPage.this.fTableViewer.refresh();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(RefactoringMessages.getString("UseSupertypeInputPage.Select_supertype_to_use"));
        label.setLayoutData((Object)new GridData());
        this.addTableComponent(composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void addTableComponent(Composite composite) {
        this.fTableViewer = new TableViewer(composite, 2820);
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableLabelProvider = new UseSupertypeLabelProvider(this.fFileCount);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (new Integer(0).equals(UseSupertypeInputPage.this.fFileCount.get(ss.getFirstElement()))) {
                    UseSupertypeInputPage.this.setMessage(RefactoringMessages.getString("UseSupertypeInputPage.No_updates"), 1);
                    UseSupertypeInputPage.this.setPageComplete(false);
                } else {
                    UseSupertypeInputPage.this.setMessage(MESSAGE);
                    UseSupertypeInputPage.this.setPageComplete(true);
                }
                UseSupertypeInputPage.this.fTableViewer.refresh();
            }
        });
        try {
            this.fTableViewer.setInput((Object)this.getUseSupertypeRefactoring().getSuperTypes());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("UseSupertypeInputPage.Use_Supertype"), RefactoringMessages.getString("UseSupertypeInputPage.Internal_Error"));
            this.fTableViewer.setInput((Object)new IType[0]);
        }
        this.fTableViewer.getTable().setSelection(0);
    }

    private UseSupertypeWherePossibleRefactoring getUseSupertypeRefactoring() {
        return (UseSupertypeWherePossibleRefactoring)this.getRefactoring();
    }

    public IWizardPage getNextPage() {
        try {
            IChange change;
            this.initializeRefactoring();
            IWizardPage nextPage = super.getNextPage();
            IStructuredSelection ss = (IStructuredSelection)this.fTableViewer.getSelection();
            IType selectedType = (IType)ss.getFirstElement();
            if (nextPage == this) {
                this.setMessage(RefactoringMessages.getString("UseSupertypeInputPage.No_updates"), 1);
                this.setPageComplete(false);
                this.fFileCount.put(selectedType, new Integer(0));
            } else if (nextPage instanceof IPreviewWizardPage && (change = this.getRefactoringWizard().getChange()) instanceof ICompositeChange) {
                ICompositeChange cc = (ICompositeChange)change;
                this.fFileCount.put(selectedType, new Integer(cc.getChildren().length));
            }
            this.fTableViewer.refresh();
            return nextPage;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public boolean performFinish() {
        try {
            this.initializeRefactoring();
            return super.performFinish();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private void initializeRefactoring() throws JavaModelException {
        StructuredSelection ss = (StructuredSelection)this.fTableViewer.getSelection();
        this.getUseSupertypeRefactoring().setSuperTypeToUse((IType)ss.getFirstElement());
    }

    public void dispose() {
        this.fTableViewer = null;
        this.fFileCount.clear();
        this.fTableLabelProvider = null;
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fTableViewer != null) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    private static class UseSupertypeLabelProvider
    extends JavaElementLabelProvider {
        private final Map fFileCount;

        UseSupertypeLabelProvider(Map fileCount) {
            this.fFileCount = fileCount;
        }

        public String getText(Object element) {
            String superText = super.getText(element);
            if (!this.fFileCount.containsKey(element)) {
                return superText;
            }
            int count = (Integer)this.fFileCount.get(element);
            if (count == 0) {
                Object[] keys = new String[]{superText};
                return RefactoringMessages.getFormattedString("UseSupertypeInputPage.no_possible_updates", keys);
            }
            if (count == 1) {
                Object[] keys = new String[]{superText};
                return RefactoringMessages.getFormattedString("UseSupertypeInputPage.updates_possible_in_file", keys);
            }
            Object[] keys = new String[]{superText, String.valueOf(count)};
            return RefactoringMessages.getFormattedString("UseSupertypeInputPage.updates_possible_in_files", keys);
        }
    }
}

