/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

abstract class TextInputWizardPage
extends UserInputWizardPage {
    private String fInitialValue;
    private Text fTextField;
    public static final String PAGE_NAME = "TextInputPage";

    public TextInputWizardPage(String description, boolean isLastUserPage) {
        this(description, isLastUserPage, "");
    }

    public TextInputWizardPage(String description, boolean isLastUserPage, String initialValue) {
        super(PAGE_NAME, isLastUserPage);
        Assert.isNotNull((Object)initialValue);
        this.setDescription(description);
        this.fInitialValue = initialValue;
    }

    protected boolean isInitialInputValid() {
        return false;
    }

    protected boolean isEmptyInputValid() {
        return false;
    }

    protected String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    protected void setText(String text) {
        if (this.fTextField == null) {
            return;
        }
        this.fTextField.setText(text);
    }

    protected RefactoringStatus validateTextField(String text) {
        return null;
    }

    protected Text createTextInputField(Composite parent) {
        return this.createTextInputField(parent, 2048);
    }

    protected Text createTextInputField(Composite parent, int style) {
        this.fTextField = new Text(parent, style);
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextInputWizardPage.this.textModified(TextInputWizardPage.this.getText());
            }
        });
        this.fTextField.setText(this.fInitialValue);
        return this.fTextField;
    }

    protected void textModified(String text) {
        if (!this.isEmptyInputValid() && text.equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        if (!this.isInitialInputValid() && text.equals(this.fInitialValue)) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        this.setPageComplete(this.validateTextField(text));
    }

    protected void restoreMessage() {
        this.setMessage(null);
    }

    public void dispose() {
        this.fTextField = null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.textModified(this.getText());
        }
        super.setVisible(visible);
        if (visible && this.fTextField != null) {
            this.fTextField.setFocus();
        }
    }
}

