/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.ui.refactoring.IErrorContextViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class SourceContextViewer
extends SourceViewer
implements IErrorContextViewer {
    SourceContextViewer(Composite parent) {
        super(parent, null, 66306);
        this.setEditable(false);
        this.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
    }

    public void setInput(Object input) {
        if (input instanceof SourceContextInput) {
            SourceContextInput scinput = (SourceContextInput)input;
            this.configure(scinput.configuration);
            Control ctrl = this.getControl();
            if (ctrl != null && ctrl.isDisposed()) {
                ctrl = null;
            }
            try {
                if (ctrl != null) {
                    ctrl.setRedraw(false);
                }
                super.setInput((Object)scinput.document);
                if (scinput.sourceRange != null) {
                    int offset = scinput.sourceRange.getOffset();
                    int length = scinput.sourceRange.getLength();
                    if (offset >= 0 && length >= 0) {
                        this.setSelectedRange(offset, length);
                        this.revealRange(offset, length);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ctrl != null) {
                    ctrl.setRedraw(true);
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (ctrl != null) {
                ctrl.setRedraw(true);
            }
        } else {
            super.setInput(input);
        }
    }

    public static class SourceContextInput {
        public IDocument document;
        public SourceViewerConfiguration configuration;
        public ISourceRange sourceRange;

        public SourceContextInput(IDocument d, SourceViewerConfiguration c, ISourceRange r) {
            this.document = d;
            this.configuration = c;
            this.sourceRange = r;
        }
    }
}

