/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RenameInputWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class RenameRefactoringWizard
extends RefactoringWizard {
    private String fPageMessage;
    private String fPageContextHelpId;
    private ImageDescriptor fInputPageImageDescriptor;

    public RenameRefactoringWizard(IRenameRefactoring ref, String title, String message, String pageContextHelpId, String errorContextHelpId) {
        super((Refactoring)((Object)ref), title, errorContextHelpId);
        this.fPageMessage = message;
        this.fPageContextHelpId = pageContextHelpId;
    }

    public void setInputPageImageDescriptor(ImageDescriptor desc) {
        this.fInputPageImageDescriptor = desc;
    }

    protected String getPageContextHelpId() {
        return this.fPageContextHelpId;
    }

    protected void addUserInputPages() {
        String initialSetting = this.getRenameRefactoring().getCurrentName();
        this.setPageTitle(this.getPageTitle());
        RenameInputWizardPage inputPage = this.createInputPage(this.fPageMessage, initialSetting);
        inputPage.setImageDescriptor(this.fInputPageImageDescriptor);
        this.addPage((IWizardPage)inputPage);
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, this.fPageContextHelpId, true, initialSetting){

            protected RefactoringStatus validateTextField(String text) {
                return RenameRefactoringWizard.this.validateNewName(text);
            }
        };
    }

    private IRenameRefactoring getRenameRefactoring() {
        return (IRenameRefactoring)((Object)this.getRefactoring());
    }

    protected RefactoringStatus validateNewName(String newName) {
        IRenameRefactoring ref = this.getRenameRefactoring();
        ref.setNewName(newName);
        try {
            return ref.checkNewName(newName);
        }
        catch (JavaModelException e) {
            String msg = e.getMessage() == null ? "" : e.getMessage();
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getFormattedString("RenameRefactoringWizard.internal_error", msg));
        }
    }
}

