/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private QualifiedNameComponent fQualifiedNameComponent;

    public RenameInputWizardPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, isLastUserPage, initialValue);
        this.fHelpContextID = contextHelpId;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)text, 1);
        this.addOptionalUpdateReferencesCheckbox(composite, layouter);
        this.addOptionalUpdateCommentsAndStringCheckboxes(composite, layouter);
        this.addOptionalUpdateQualifiedNameComponent(composite, layouter, layout.marginWidth);
        Dialog.applyDialogFont((Control)superComposite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)this.fHelpContextID);
    }

    public void dispose() {
        if (this.fQualifiedNameComponent != null) {
            boolean save = true;
            if (this.getContainer() instanceof Dialog) {
                boolean bl = save = ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            if (save) {
                this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
            }
        }
        super.dispose();
    }

    private void addOptionalUpdateCommentsAndStringCheckboxes(Composite result, RowLayouter layouter) {
        if (!(this.getRefactoring() instanceof ITextUpdatingRefactoring)) {
            return;
        }
        ITextUpdatingRefactoring refactoring = (ITextUpdatingRefactoring)((Object)this.getRefactoring());
        if (!refactoring.canEnableTextUpdating()) {
            return;
        }
        this.addUpdateJavaDocCheckbox(result, layouter, refactoring);
        this.addUpdateCommentsCheckbox(result, layouter, refactoring);
        this.addUpdateStringsCheckbox(result, layouter, refactoring);
    }

    private void addOptionalUpdateReferencesCheckbox(Composite result, RowLayouter layouter) {
        if (!(this.getRefactoring() instanceof IReferenceUpdatingRefactoring)) {
            return;
        }
        final IReferenceUpdatingRefactoring ref = (IReferenceUpdatingRefactoring)((Object)this.getRefactoring());
        if (!ref.canEnableUpdateReferences()) {
            return;
        }
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_references");
        boolean defaultValue = ref.getUpdateReferences();
        final Button checkBox = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        ref.setUpdateReferences(checkBox.getSelection());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(checkBox.getSelection());
            }
        });
    }

    private void addUpdateStringsCheckbox(Composite result, RowLayouter layouter, final ITextUpdatingRefactoring refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.ppdate_string_references");
        boolean defaultValue = refactoring.getUpdateStrings();
        final Button checkBox = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateStrings(checkBox.getSelection());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateStrings(checkBox.getSelection());
                RenameInputWizardPage.this.updatePreviewReview();
            }
        });
    }

    private void addUpdateCommentsCheckbox(Composite result, RowLayouter layouter, final ITextUpdatingRefactoring refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_comment_references");
        boolean defaultValue = refactoring.getUpdateComments();
        final Button checkBox = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateComments(checkBox.getSelection());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateComments(checkBox.getSelection());
                RenameInputWizardPage.this.updatePreviewReview();
            }
        });
    }

    private void addUpdateJavaDocCheckbox(Composite result, RowLayouter layouter, final ITextUpdatingRefactoring refactoring) {
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_javadoc_references");
        boolean defaultValue = refactoring.getUpdateJavaDoc();
        final Button checkBox = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateJavaDoc(checkBox.getSelection());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateJavaDoc(checkBox.getSelection());
                RenameInputWizardPage.this.updatePreviewReview();
            }
        });
    }

    private void addOptionalUpdateQualifiedNameComponent(Composite parent, RowLayouter layouter, int marginWidth) {
        if (!(this.getRefactoring() instanceof IQualifiedNameUpdatingRefactoring)) {
            return;
        }
        final IQualifiedNameUpdatingRefactoring ref = (IQualifiedNameUpdatingRefactoring)((Object)this.getRefactoring());
        if (!ref.canEnableQualifiedNameUpdating()) {
            return;
        }
        Button checkbox = new Button(parent, 32);
        int indent = marginWidth + checkbox.computeSize((int)-1, (int)-1).x;
        checkbox.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
        layouter.perform((Control)checkbox);
        this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, ref, this.getRefactoringSettings());
        layouter.perform((Control)this.fQualifiedNameComponent);
        GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = indent;
        this.fQualifiedNameComponent.setEnabled(false);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                RenameInputWizardPage.this.fQualifiedNameComponent.setEnabled(enabled);
                ref.setUpdateQualifiedNames(enabled);
                RenameInputWizardPage.this.updatePreviewReview();
            }
        });
    }

    protected String getLabelText() {
        return RefactoringMessages.getString("RenameInputWizardPage.enter_name");
    }

    private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        layouter.perform((Control)checkBox);
        return checkBox;
    }

    private void updatePreviewReview() {
        boolean previewReview = false;
        Refactoring ref = this.getRefactoring();
        if (ref instanceof ITextUpdatingRefactoring) {
            ITextUpdatingRefactoring tur = (ITextUpdatingRefactoring)((Object)ref);
            boolean bl = previewReview = tur.getUpdateComments() || tur.getUpdateJavaDoc() || tur.getUpdateStrings();
        }
        if (ref instanceof IQualifiedNameUpdatingRefactoring) {
            previewReview |= ((IQualifiedNameUpdatingRefactoring)((Object)ref)).getUpdateQualifiedNames();
        }
        this.getRefactoringWizard().setPreviewReview(previewReview);
    }
}

