/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RenameInputWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class RenameFieldInputWizardPage
extends RenameInputWizardPage {
    private Button fRenameGetter;
    private Button fRenameSetter;
    private String fGetterRenamingErrorMessage;
    private String fSetterRenamingErrorMessage;

    public RenameFieldInputWizardPage(String message, String contextHelpId, String initialValue) {
        super(message, contextHelpId, true, initialValue);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite parentComposite = (Composite)this.getControl();
        Composite composite = new Composite(parentComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.getGetterSetterRenamingEnablement();
        this.fRenameGetter = new Button(composite, 32);
        this.fRenameGetter.setEnabled(this.fGetterRenamingErrorMessage == null);
        this.fRenameGetter.setSelection(this.getRenameFieldRefactoring().getRenameGetter());
        this.fRenameGetter.setLayoutData((Object)new GridData(768));
        this.fRenameGetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameFieldInputWizardPage.this.getRenameFieldRefactoring().setRenameGetter(RenameFieldInputWizardPage.this.fRenameGetter.getSelection());
            }
        });
        this.fRenameSetter = new Button(composite, 32);
        this.fRenameSetter.setEnabled(this.fSetterRenamingErrorMessage == null);
        this.fRenameSetter.setSelection(this.getRenameFieldRefactoring().getRenameSetter());
        this.fRenameSetter.setLayoutData((Object)new GridData(768));
        this.fRenameSetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameFieldInputWizardPage.this.getRenameFieldRefactoring().setRenameSetter(RenameFieldInputWizardPage.this.fRenameSetter.getSelection());
            }
        });
        this.updateGetterSetterLabels();
        Dialog.applyDialogFont((Control)composite);
    }

    private void getGetterSetterRenamingEnablement() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                RenameFieldInputWizardPage.this.checkGetterRenamingEnablement();
                RenameFieldInputWizardPage.this.checkSetterRenamingEnablement();
            }
        });
    }

    protected void updateGetterSetterLabels() {
        this.fRenameGetter.setText(this.getRenameGetterLabel());
        this.fRenameSetter.setText(this.getRenameSetterLabel());
    }

    private String getRenameGetterLabel() {
        String defaultLabel = RefactoringMessages.getString("RenameFieldInputWizardPage.rename_getter");
        if (this.fGetterRenamingErrorMessage != null) {
            return this.constructDisabledGetterRenamingLabel(defaultLabel);
        }
        try {
            IMethod getter = this.getRenameFieldRefactoring().getGetter();
            if (getter == null || !getter.exists()) {
                return defaultLabel;
            }
            String getterSig = JavaElementUtil.createMethodSignature(getter);
            return RefactoringMessages.getFormattedString("RenameFieldInputWizardPage.rename_getter_to", new String[]{getterSig, this.createNewGetterName()});
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return defaultLabel;
        }
    }

    private String getRenameSetterLabel() {
        String defaultLabel = RefactoringMessages.getString("RenameFieldInputWizardPage.rename_setter");
        if (this.fSetterRenamingErrorMessage != null) {
            return this.constructDisabledSetterRenamingLabel(defaultLabel);
        }
        try {
            IMethod setter = this.getRenameFieldRefactoring().getSetter();
            if (setter == null || !setter.exists()) {
                return defaultLabel;
            }
            String setterSig = JavaElementUtil.createMethodSignature(setter);
            return RefactoringMessages.getFormattedString("RenameFieldInputWizardPage.rename_setter_to", new String[]{setterSig, this.createNewSetterName()});
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return defaultLabel;
        }
    }

    private String constructDisabledSetterRenamingLabel(String defaultLabel) {
        if (this.fSetterRenamingErrorMessage.equals("")) {
            return defaultLabel;
        }
        Object[] keys = new String[]{defaultLabel, this.fSetterRenamingErrorMessage};
        return RefactoringMessages.getFormattedString("RenameFieldInputWizardPage.setter_label", keys);
    }

    private String constructDisabledGetterRenamingLabel(String defaultLabel) {
        if (this.fGetterRenamingErrorMessage.equals("")) {
            return defaultLabel;
        }
        Object[] keys = new String[]{defaultLabel, this.fGetterRenamingErrorMessage};
        return RefactoringMessages.getFormattedString("RenameFieldInputWizardPage.getter_label", keys);
    }

    private String createNewGetterName() throws JavaModelException {
        return this.getRenameFieldRefactoring().getNewGetterName();
    }

    private String createNewSetterName() throws JavaModelException {
        return this.getRenameFieldRefactoring().getNewSetterName();
    }

    private String checkGetterRenamingEnablement() {
        if (this.fGetterRenamingErrorMessage != null) {
            return this.fGetterRenamingErrorMessage;
        }
        try {
            this.fGetterRenamingErrorMessage = this.getRenameFieldRefactoring().canEnableGetterRenaming();
            return this.fGetterRenamingErrorMessage;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return "";
        }
    }

    private String checkSetterRenamingEnablement() {
        if (this.fSetterRenamingErrorMessage != null) {
            return this.fSetterRenamingErrorMessage;
        }
        try {
            this.fSetterRenamingErrorMessage = this.getRenameFieldRefactoring().canEnableSetterRenaming();
            return this.fSetterRenamingErrorMessage;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return "";
        }
    }

    private RenameFieldRefactoring getRenameFieldRefactoring() {
        return (RenameFieldRefactoring)this.getRefactoring();
    }
}

