/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog
extends WizardDialog {
    private static final String DIALOG_SETTINGS = "RefactoringWizard";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings fSettings;
    private boolean fMakeNextButtonDefault;

    public RefactoringWizardDialog(Shell parent, RefactoringWizard wizard) {
        super(parent, (IWizard)wizard);
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        wizard.setDialogSettings(settings);
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 600);
            this.fSettings.put(HEIGHT, 400);
        }
        int width = 600;
        int height = 400;
        try {
            width = this.fSettings.getInt(WIDTH);
            height = this.fSettings.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
        this.setMinimumPageSize(width, height);
    }

    protected void finishPressed() {
        IWizardPage page = this.getCurrentPage();
        Composite control = page.getControl().getParent();
        Point size = control.getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
        super.finishPressed();
    }

    public void updateButtons() {
        super.updateButtons();
        if (!this.fMakeNextButtonDefault) {
            return;
        }
        if (this.getShell() == null) {
            return;
        }
        Button next = this.getButton(15);
        if (next.isEnabled()) {
            this.getShell().setDefaultButton(next);
        }
    }

    public void setMakeNextButtonDefault(boolean makeNextButtonDefault) {
        this.fMakeNextButtonDefault = makeNextButtonDefault;
    }
}

