/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformRefactoringUtil;
import org.eclipse.jdt.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

public class RefactoringWizard
extends Wizard {
    private String fPageTitle;
    private Refactoring fRefactoring;
    private IChange fChange;
    private RefactoringStatus fActivationStatus = new RefactoringStatus();
    private RefactoringStatus fStatus;
    private boolean fHasUserInputPages;
    private boolean fExpandFirstNode;
    private boolean fIsChangeCreationCancelable;
    private boolean fPreviewReview;
    private boolean fPreviewShown;
    private String fErrorPageContextHelpId;

    public RefactoringWizard(Refactoring ref, String pageTitle, String errorPageContextHelpId) {
        this.setNeedsProgressMonitor(true);
        Assert.isNotNull(pageTitle);
        Assert.isNotNull(ref);
        this.fRefactoring = ref;
        this.fPageTitle = pageTitle;
        this.fErrorPageContextHelpId = errorPageContextHelpId;
        this.fIsChangeCreationCancelable = true;
        this.setWindowTitle(RefactoringMessages.getString("RefactoringWizard.title"));
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR);
    }

    public void setChangeCreationCancelable(boolean isChangeCreationCancelable) {
        this.fIsChangeCreationCancelable = isChangeCreationCancelable;
    }

    protected boolean checkActivationOnOpen() {
        return false;
    }

    protected void addUserInputPages() {
    }

    protected void addErrorPage() {
        this.addPage((IWizardPage)new ErrorWizardPage(this.fErrorPageContextHelpId));
    }

    protected void addPreviewPage() {
        this.addPage(new PreviewWizardPage());
    }

    public boolean hasMultiPageUserInput() {
        return false;
    }

    protected int getMessageLineWidthInChars() {
        return 80;
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    public boolean hasUserInputPages() {
        return this.fHasUserInputPages;
    }

    public void setChange(IChange change) {
        IPreviewWizardPage page = (IPreviewWizardPage)this.getPage("PreviewPage");
        if (page != null) {
            page.setChange(change);
        }
        this.fChange = change;
    }

    public IChange getChange() {
        return this.fChange;
    }

    public void setStatus(RefactoringStatus status) {
        ErrorWizardPage page = (ErrorWizardPage)this.getPage("ErrorPage");
        if (page != null) {
            page.setStatus(status);
        }
        this.fStatus = status;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void setInputStatus(RefactoringStatus status) {
        RefactoringStatus newStatus = new RefactoringStatus();
        if (this.fActivationStatus != null) {
            newStatus.merge(this.fActivationStatus);
        }
        newStatus.merge(status);
        this.setStatus(newStatus);
    }

    public void setActivationStatus(RefactoringStatus status) {
        this.fActivationStatus = status;
        this.setStatus(status);
    }

    public RefactoringStatus getActivationStatus() {
        return this.fActivationStatus;
    }

    public String getPageTitle() {
        return this.fPageTitle;
    }

    public void setPageTitle(String title) {
        this.fPageTitle = title;
        this.setupPageTitles();
    }

    public void setExpandFirstNode(boolean expand) {
        this.fExpandFirstNode = true;
    }

    public boolean getExpandFirstNode() {
        return this.fExpandFirstNode;
    }

    public IWizardPage computeUserInputSuccessorPage(IWizardPage caller) {
        return this.computeUserInputSuccessorPage(caller, (IRunnableContext)this.getContainer());
    }

    private IWizardPage computeUserInputSuccessorPage(IWizardPage caller, IRunnableContext context) {
        IChange change = this.createChange(4, 0, true, context);
        RefactoringStatus status = this.getStatus();
        if (change == null && status == null) {
            this.setChange(change);
            return caller;
        }
        if (!status.hasFatalError()) {
            this.setChange(change);
        }
        if (status.isOK()) {
            return this.getPage("PreviewPage");
        }
        return this.getPage("ErrorPage");
    }

    protected void setupPageTitles() {
        if (this.fPageTitle == null) {
            return;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            pages[i].setTitle(this.fPageTitle);
            ++i;
        }
    }

    public void setPreviewReview(boolean review) {
        this.fPreviewReview = review;
        this.getContainer().updateButtons();
    }

    public void setPreviewShown(boolean shown) {
        this.fPreviewShown = shown;
        this.getContainer().updateButtons();
    }

    public boolean canFinish() {
        if (this.fPreviewReview && !this.fPreviewShown) {
            return false;
        }
        return super.canFinish();
    }

    IChange createChange(int style, int checkPassedSeverity, boolean updateStatus) {
        return this.createChange(style, checkPassedSeverity, updateStatus, (IRunnableContext)this.getContainer());
    }

    private IChange createChange(int style, int checkPassedSeverity, boolean updateStatus, IRunnableContext context) {
        CreateChangeOperation op = new CreateChangeOperation(this.fRefactoring, style);
        op.setCheckPassedSeverity(checkPassedSeverity);
        InvocationTargetException exception = null;
        try {
            context.run(true, this.fIsChangeCreationCancelable, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            this.setStatus(null);
            return null;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        if (updateStatus) {
            RefactoringStatus status = null;
            if (exception != null) {
                status = new RefactoringStatus();
                String msg = exception.getMessage();
                if (msg != null) {
                    status.addFatalError(RefactoringMessages.getFormattedString("RefactoringWizard.see_log", msg));
                } else {
                    status.addFatalError(RefactoringMessages.getString("RefactoringWizard.Internal_error"));
                }
                JavaPlugin.log(exception);
            } else {
                status = op.getStatus();
            }
            this.setStatus(status, style);
        } else if (exception != null) {
            ExceptionHandler.handle(exception, RefactoringMessages.getString("RefactoringWizard.refactoring"), RefactoringMessages.getString("RefactoringWizard.unexpected_exception"));
        }
        IChange change = op.getChange();
        return change;
    }

    public boolean performFinish(PerformChangeOperation op) {
        return PerformRefactoringUtil.performRefactoring(op, this.fRefactoring, (IRunnableContext)this.getContainer(), this.getContainer().getShell());
    }

    public RefactoringStatus checkInput() {
        return this.internalCheckCondition((IRunnableContext)this.getContainer(), 4);
    }

    protected RefactoringStatus internalCheckCondition(IRunnableContext context, int style) {
        CheckConditionsOperation op = new CheckConditionsOperation(this.fRefactoring, style);
        Exception exception = null;
        try {
            context.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        RefactoringStatus status = null;
        if (exception != null) {
            JavaPlugin.log(exception);
            status = new RefactoringStatus();
            status.addFatalError(RefactoringMessages.getString("RefactoringWizard.internal_error_1"));
        } else {
            status = op.getStatus();
        }
        this.setStatus(status, style);
        return status;
    }

    protected void setStatus(RefactoringStatus status, int style) {
        if ((style & 6) == 6) {
            this.setStatus(status);
        } else if ((style & 2) == 2) {
            this.setActivationStatus(status);
        } else if ((style & 4) == 4) {
            this.setInputStatus(status);
        }
    }

    public boolean performFinish() {
        Assert.isNotNull(this.fRefactoring);
        RefactoringWizardPage page = (RefactoringWizardPage)this.getContainer().getCurrentPage();
        return page.performFinish();
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.fHasUserInputPages) {
            return super.getPreviousPage(page);
        }
        if (!page.getName().equals("ErrorPage") && this.fStatus.isOK()) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    public IWizardPage getStartingPage() {
        if (this.fHasUserInputPages) {
            return super.getStartingPage();
        }
        return this.computeUserInputSuccessorPage(null, (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void addPages() {
        if (this.checkActivationOnOpen()) {
            this.internalCheckCondition(new BusyIndicatorRunnableContext(), 2);
        }
        if (this.fActivationStatus.hasFatalError()) {
            this.addErrorPage();
            this.setStatus(this.getStatus());
        } else {
            Assert.isTrue(this.getPageCount() == 0);
            this.addUserInputPages();
            if (this.getPageCount() > 0) {
                this.fHasUserInputPages = true;
            }
            this.addErrorPage();
            this.addPreviewPage();
        }
        this.setupPageTitles();
    }

    public void addPage(IWizardPage page) {
        Assert.isTrue(page instanceof RefactoringWizardPage);
        super.addPage(page);
    }
}

