/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameResourceRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameSourceFolderRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RenameFieldWizard;
import org.eclipse.jdt.internal.ui.refactoring.RenameRefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.reorg.IRefactoringRenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class RefactoringSupport {
    private static RefactoringWizard createRenameWizard(IRenameRefactoring ref, String title, String message, String wizardPageHelp, String errorPageHelp, ImageDescriptor image) {
        RenameRefactoringWizard w = new RenameRefactoringWizard(ref, title, message, wizardPageHelp, errorPageHelp);
        w.setInputPageImageDescriptor(image);
        return w;
    }

    static abstract class AbstractRenameSupport
    implements IRefactoringRenameSupport {
        IRenameRefactoring fRefactoring;

        protected AbstractRenameSupport(IRenameRefactoring refactoring) {
            this.fRefactoring = refactoring;
        }

        public RefactoringStatus lightCheck() throws JavaModelException {
            return this.lightCheck(this.fRefactoring);
        }

        public abstract RefactoringStatus lightCheck(IRenameRefactoring var1) throws JavaModelException;

        public IRenameRefactoring getRefactoring() {
            return this.fRefactoring;
        }

        public boolean canRename(Object element) throws JavaModelException {
            boolean canRename;
            if (this.fRefactoring instanceof RenameMethodRefactoring && element instanceof IMethod) {
                this.fRefactoring = RenameMethodRefactoring.createInstance((IMethod)element, (RenameMethodRefactoring)this.fRefactoring);
            }
            if (!(canRename = this.lightCheck().isOK())) {
                this.fRefactoring = null;
            }
            return canRename;
        }

        public void rename(Shell parent, Object element) throws JavaModelException {
            Assert.isNotNull((Object)this.fRefactoring);
            RefactoringWizard wizard = this.createWizard(this.fRefactoring);
            RefactoringStarter starter = new RefactoringStarter();
            SelectionState state = new SelectionState(element);
            Object newElementToRename = wizard != null ? starter.activate((Refactoring)((Object)this.fRefactoring), wizard, parent, RefactoringMessages.getString("RefactoringSupportFactory.rename"), true) : starter.activate(this.fRefactoring, parent, RefactoringMessages.getString("RefactoringSupportFactory.rename"), this.getNameEntryMessage(), false, element);
            if (newElementToRename == null) {
                state.restore(this.fRefactoring.getNewElement());
                this.fRefactoring = null;
            } else if (this.canRename(newElementToRename)) {
                this.rename(parent, newElementToRename);
            } else {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)RefactoringMessages.getString("RefactoringSupportFactory.error.title"), (String)RefactoringMessages.getString("RefactoringSupportFactory.error.message"));
            }
        }

        public RefactoringWizard createWizard(IRenameRefactoring ref) {
            return null;
        }

        String getNameEntryMessage() {
            return "";
        }

        private static class SelectionState {
            private Display fDisplay;
            private Object fElement;
            private List fParts;
            private List fSelections;
            static /* synthetic */ Class class$0;

            public SelectionState(Object element) {
                this.fElement = element;
                this.fParts = new ArrayList();
                this.fSelections = new ArrayList();
                this.init();
            }

            private void init() {
                IWorkbenchWindow dw = JavaPlugin.getActiveWorkbenchWindow();
                if (dw == null) {
                    return;
                }
                this.fDisplay = dw.getShell().getDisplay();
                IWorkbenchPage page = dw.getActivePage();
                if (page == null) {
                    return;
                }
                IViewReference[] vrefs = page.getViewReferences();
                int i = 0;
                while (i < vrefs.length) {
                    this.consider(vrefs[i].getPart(false));
                    ++i;
                }
                IEditorReference[] refs = page.getEditorReferences();
                int i2 = 0;
                while (i2 < refs.length) {
                    this.consider(refs[i2].getPart(false));
                    ++i2;
                }
            }

            private void consider(IWorkbenchPart part) {
                ISelection s;
                if (part == null) {
                    return;
                }
                ISetSelectionTarget target = null;
                if (!(part instanceof ISetSelectionTarget)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((target = (ISetSelectionTarget)part.getAdapter((Class)clazz)) == null) {
                        return;
                    }
                } else {
                    target = (ISetSelectionTarget)part;
                }
                if (!((s = part.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)s;
                if (!selection.toList().contains(this.fElement)) {
                    return;
                }
                this.fParts.add(part);
                this.fSelections.add(selection);
            }

            public void restore(Object newElement) {
                if (this.fDisplay == null) {
                    return;
                }
                int i = 0;
                while (i < this.fParts.size()) {
                    IStructuredSelection selection = (IStructuredSelection)this.fSelections.get(i);
                    ISetSelectionTarget target = (ISetSelectionTarget)this.fParts.get(i);
                    List l = selection.toList();
                    int index = l.indexOf(this.fElement);
                    if (index != -1) {
                        l.set(index, newElement);
                        this.fDisplay.asyncExec(new Runnable(target, selection){
                            private final /* synthetic */ ISetSelectionTarget val$target;
                            private final /* synthetic */ IStructuredSelection val$selection;
                            {
                                this.val$target = iSetSelectionTarget;
                                this.val$selection = iStructuredSelection;
                            }

                            public void run() {
                                this.val$target.selectReveal((ISelection)this.val$selection);
                            }
                        });
                    }
                    ++i;
                }
            }
        }
    }

    public static class JavaProject
    extends AbstractRenameSupport {
        public JavaProject(IJavaProject project) {
            super(new RenameJavaProjectRefactoring(project));
        }

        public RenameJavaProjectRefactoring getSpecificRefactoring() {
            return (RenameJavaProjectRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameJavaProjectRefactoring)refactoring).checkActivation((IProgressMonitor)new NullProgressMonitor());
        }

        String getNameEntryMessage() {
            return RefactoringMessages.getString("RefactoringSupportFactory.project_name");
        }
    }

    public static class SourceFolder
    extends AbstractRenameSupport {
        public SourceFolder(IPackageFragmentRoot root) {
            super(new RenameSourceFolderRefactoring(root));
        }

        public RenameSourceFolderRefactoring getSpecificRefactoring() {
            return (RenameSourceFolderRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameSourceFolderRefactoring)refactoring).checkActivation((IProgressMonitor)new NullProgressMonitor());
        }

        String getNameEntryMessage() {
            return RefactoringMessages.getString("RefactoringSupportFactory.source_folder_name");
        }
    }

    public static class PackageFragment
    extends AbstractRenameSupport {
        public PackageFragment(IPackageFragment element) {
            super(new RenamePackageRefactoring(element));
        }

        public RenamePackageRefactoring getSpecificRefactoring() {
            return (RenamePackageRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenamePackageRefactoring)refactoring).checkActivation((IProgressMonitor)new NullProgressMonitor());
        }

        public RefactoringWizard createWizard(IRenameRefactoring refactoring) {
            String title = RefactoringMessages.getString("RefactoringSupportFactory.rename_Package");
            String message = RefactoringMessages.getString("RefactoringSupportFactory.package_name");
            String wizardPageHelp = "org.eclipse.jdt.ui.rename_package_wizard_page_context";
            String errorPageHelp = "org.eclipse.jdt.ui.rename_package_error_wizard_page_context";
            ImageDescriptor imageDesc = JavaPluginImages.DESC_WIZBAN_REFACTOR_PACKAGE;
            return RefactoringSupport.createRenameWizard(refactoring, title, message, wizardPageHelp, errorPageHelp, imageDesc);
        }
    }

    public static class CompilationUnit
    extends AbstractRenameSupport {
        public CompilationUnit(ICompilationUnit unit) {
            super(CompilationUnit.createRefactoring(unit));
        }

        public RenameCompilationUnitRefactoring getSpecificRefactoring() {
            return (RenameCompilationUnitRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameCompilationUnitRefactoring)refactoring).checkPreactivation();
        }

        public RefactoringWizard createWizard(IRenameRefactoring refactoring) {
            String title = RefactoringMessages.getString("RefactoringSupportFactory.rename_Cu");
            String message = RefactoringMessages.getString("RefactoringSupportFactory.compilation_unit");
            String wizardPageHelp = "org.eclipse.jdt.ui.rename_cu_wizard_page_context";
            String errorPageHelp = "org.eclipse.jdt.ui.rename_cu_error_wizard_page_context";
            ImageDescriptor imageDesc = JavaPluginImages.DESC_WIZBAN_REFACTOR_CU;
            return RefactoringSupport.createRenameWizard(refactoring, title, message, wizardPageHelp, errorPageHelp, imageDesc);
        }

        private static IRenameRefactoring createRefactoring(ICompilationUnit element) {
            ICompilationUnit cu = element;
            if (cu.isWorkingCopy()) {
                return new RenameCompilationUnitRefactoring((ICompilationUnit)cu.getOriginalElement());
            }
            return new RenameCompilationUnitRefactoring(cu);
        }
    }

    public static class Type
    extends AbstractRenameSupport {
        public Type(IType element) {
            super(new RenameTypeRefactoring(element));
        }

        public RenameTypeRefactoring getSpecificRefactoring() {
            return (RenameTypeRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameTypeRefactoring)refactoring).checkPreactivation();
        }

        public RefactoringWizard createWizard(IRenameRefactoring refactoring) {
            String title = RefactoringMessages.getString("RefactoringGroup.rename_type_title");
            String message = RefactoringMessages.getString("RefactoringGroup.rename_type_message");
            String wizardPageHelp = "org.eclipse.jdt.ui.rename_type_wizard_page_context";
            String errorPageHelp = "org.eclipse.jdt.ui.rename_type_error_wizard_page_context";
            ImageDescriptor imageDesc = JavaPluginImages.DESC_WIZBAN_REFACTOR_TYPE;
            return RefactoringSupport.createRenameWizard(refactoring, title, message, wizardPageHelp, errorPageHelp, imageDesc);
        }
    }

    public static class Method
    extends AbstractRenameSupport {
        public Method(IMethod element) throws JavaModelException {
            super(RenameMethodRefactoring.createInstance(element));
        }

        public RenameMethodRefactoring getSpecificRefactoring() {
            return (RenameMethodRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameMethodRefactoring)refactoring).checkPreactivation();
        }

        public RefactoringWizard createWizard(IRenameRefactoring refactoring) {
            String title = RefactoringMessages.getString("RefactoringGroup.rename_method_title");
            String message = RefactoringMessages.getString("RefactoringGroup.rename_method_message");
            String wizardPageHelp = "org.eclipse.jdt.ui.rename_method_wizard_page_context";
            String errorPageHelp = "org.eclipse.jdt.ui.rename_method_error_wizard_page_context";
            ImageDescriptor imageDesc = JavaPluginImages.DESC_WIZBAN_REFACTOR_METHOD;
            return RefactoringSupport.createRenameWizard(refactoring, title, message, wizardPageHelp, errorPageHelp, imageDesc);
        }
    }

    public static class Field
    extends AbstractRenameSupport {
        public Field(IField element) {
            super(new RenameFieldRefactoring(element));
        }

        public RenameFieldRefactoring getSpecificRefactoring() {
            return (RenameFieldRefactoring)this.fRefactoring;
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameFieldRefactoring)refactoring).checkPreactivation();
        }

        public RefactoringWizard createWizard(IRenameRefactoring refactoring) {
            String title = RefactoringMessages.getString("RefactoringGroup.rename_field_title");
            String message = RefactoringMessages.getString("RefactoringGroup.rename_field_message");
            String wizardPageHelp = "org.eclipse.jdt.ui.rename_field_wizard_page_context";
            String errorPageHelp = "org.eclipse.jdt.ui.rename_field_error_wizard_page_context";
            ImageDescriptor imageDesc = JavaPluginImages.DESC_WIZBAN_REFACTOR_CU;
            RenameFieldWizard w = new RenameFieldWizard(refactoring, title, message, wizardPageHelp, errorPageHelp);
            w.setInputPageImageDescriptor(imageDesc);
            return w;
        }
    }

    public static class Resource
    extends AbstractRenameSupport {
        public Resource(IResource element) {
            super(new RenameResourceRefactoring(element));
        }

        public RefactoringStatus lightCheck(IRenameRefactoring refactoring) throws JavaModelException {
            return ((RenameResourceRefactoring)refactoring).checkActivation((IProgressMonitor)new NullProgressMonitor());
        }

        String getNameEntryMessage() {
            return RefactoringMessages.getString("RefactoringSupportFactory.resource_name");
        }
    }
}

