/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.jdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;

    public boolean saveEditors() {
        IEditorPart[] dirtyEditors = JavaPlugin.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors()) {
            return false;
        }
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                JavaPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false);
                this.fFilesSaved = true;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            Object var6_9 = null;
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, RefactoringMessages.getString("RefactoringStarter.saving"), RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(JavaPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors() {
        if (RefactoringPreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(JavaPlugin.getActiveWorkbenchShell()){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Button check = new Button(result, 32);
                check.setText(RefactoringMessages.getString("RefactoringStarter.always_save"));
                check.setSelection(RefactoringPreferences.getSaveAllEditors());
                check.addSelectionListener((SelectionListener)new SelectionAdapter(check){
                    private final /* synthetic */ Button val$check;
                    {
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        RefactoringPreferences.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                Dialog.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.getString("RefactoringStarter.save_all_resources"));
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.getString("RefactoringStarter.must_save"));
        dialog.setContentProvider(new ListContentProvider());
        dialog.setInput(Arrays.asList(JavaPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

