/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class RefactoringPreferences {
    public static final String PREF_ERROR_PAGE_SEVERITY_THRESHOLD = "Refactoring.ErrorPage.severityThreshold";
    public static final String PREF_SAVE_ALL_EDITORS = "Refactoring.savealleditors";

    public static int getCheckPassedSeverity() {
        String value = JavaPlugin.getDefault().getPreferenceStore().getString(PREF_ERROR_PAGE_SEVERITY_THRESHOLD);
        try {
            return Integer.valueOf(value) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return 3;
        }
    }

    public static int getStopSeverity() {
        switch (RefactoringPreferences.getCheckPassedSeverity()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public static boolean getSaveAllEditors() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PREF_SAVE_ALL_EDITORS);
    }

    public static void setSaveAllEditors(boolean save) {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        store.setValue(PREF_SAVE_ALL_EDITORS, save);
    }
}

