/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class PushDownInputPage
extends UserInputWizardPage {
    private static final int MEMBER_COLUMN = 0;
    private static final int ACTION_COLUMN = 1;
    public static final String PAGE_NAME = "PushDownInputPage";
    private static final String ACTION_PROPERTY = "action";
    private static final String MEMBER_PROPERTY = "member";
    private static final int ROW_COUNT = 10;
    private Button fEditButton;
    private PullPushCheckboxTableViewer fTableViewer;
    private Label fStatusLine;

    public PushDownInputPage() {
        super(PAGE_NAME, true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        this.createMemberTableLabel(composite);
        this.createMemberTableComposite(composite);
        this.createStatusLine(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.push_down_wizard_page_context");
    }

    private void createStatusLine(Composite composite) {
        this.fStatusLine = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.updateStatusLine();
        this.fStatusLine.setLayoutData((Object)gd);
    }

    private void createMemberTableLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(RefactoringMessages.getString("PushDownInputPage.Specify_actions"));
        GridData gd0 = new GridData();
        label.setLayoutData((Object)gd0);
    }

    private void createMemberTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        this.createMemberTable(composite);
        this.createButtonComposite(composite);
    }

    private void createMemberTable(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        Table table = new Table((Composite)layouter, 68130);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(770);
        gd.heightHint = table.getHeaderHeight() + (table.getGridLineWidth() + table.getItemHeight()) * 10;
        layouter.setLayoutData(gd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setText(RefactoringMessages.getString("PushDownInputPage.Member"));
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(RefactoringMessages.getString("PushDownInputPage.Action"));
        this.fTableViewer = new PullPushCheckboxTableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PushDownInputPage.this.updateButtonEnablementState((IStructuredSelection)event.getSelection());
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                PushDownRefactoring.MemberActionInfo info = (PushDownRefactoring.MemberActionInfo)event.getElement();
                if (checked) {
                    info.setAction(0);
                } else {
                    info.setAction(2);
                }
                PushDownInputPage.this.updateUIElements(null);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PushDownInputPage.this.editSelectedMembers();
            }
        });
        this.fTableViewer.setInput(this.getPushDownRefactoring().getMemberActionInfos());
        this.updateUIElements(null);
        this.setupCellEditors(table);
    }

    private PushDownRefactoring.MemberActionInfo[] getActiveInfos() {
        PushDownRefactoring.MemberActionInfo[] infos = this.getPushDownRefactoring().getMemberActionInfos();
        ArrayList<PushDownRefactoring.MemberActionInfo> result = new ArrayList<PushDownRefactoring.MemberActionInfo>(infos.length);
        int i = 0;
        while (i < infos.length) {
            PushDownRefactoring.MemberActionInfo info = infos[i];
            if (info.isActive()) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new PushDownRefactoring.MemberActionInfo[result.size()]);
    }

    private void setupCellEditors(final Table table) {
        final ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor();
        comboBoxCellEditor.setStyle(8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = comboBoxCellEditor;
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (comboBoxCellEditor.getControl() == null & !table.isDisposed()) {
                    comboBoxCellEditor.create((Composite)table);
                }
                Assert.isTrue(event.getSelection() instanceof IStructuredSelection);
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.size() != 1) {
                    return;
                }
                PushDownRefactoring.MemberActionInfo mac = (PushDownRefactoring.MemberActionInfo)ss.getFirstElement();
                comboBoxCellEditor.setItems(MemberActionInfoLabelProvider.getAvailableActionLabels(mac));
                comboBoxCellEditor.setValue((Object)new Integer(mac.getAction()));
            }
        });
        PullUpCellModifier cellModifier = new PullUpCellModifier();
        this.fTableViewer.setCellModifier(cellModifier);
        this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
    }

    private void createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.fEditButton = new Button(composite, 8);
        this.fEditButton.setText(RefactoringMessages.getString("PushDownInputPage.Edit"));
        this.fEditButton.setLayoutData((Object)new GridData(768));
        this.fEditButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PushDownInputPage.this.editSelectedMembers();
            }
        });
        Button addButton = new Button(composite, 8);
        addButton.setText(RefactoringMessages.getString("PushDownInputPage.Add_Required"));
        addButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PushDownInputPage.this.markAdditionalRequiredMembersAsMembersToPushDown();
            }
        });
    }

    public void markAdditionalRequiredMembersAsMembersToPushDown() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        try {
                            PushDownInputPage.this.getPushDownRefactoring().computeAdditionalRequiredMembersToPushDown(pm);
                            PushDownInputPage.this.updateUIElements(null);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        pm.done();
                        throw throwable;
                    }
                    Object var3_5 = null;
                    pm.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PushDownInputPage.Push_Down"), RefactoringMessages.getString("PushDownInputPage.Internal_Error"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue(false);
        }
    }

    private void editSelectedMembers() {
        if (!this.fEditButton.isEnabled()) {
            return;
        }
        ISelection preserved = this.fTableViewer.getSelection();
        try {
            String shellTitle = RefactoringMessages.getString("PushDownInputPage.Edit_members");
            String labelText = RefactoringMessages.getString("PushDownInputPage.Mark_selected_members");
            Map stringMapping = this.createStringMappingForSelectedElements();
            Object[] keys = stringMapping.keySet().toArray(new String[stringMapping.keySet().size()]);
            Arrays.sort(keys);
            int initialSelectionIndex = this.getInitialSelectionIndexForEditDialog(stringMapping, (String[])keys);
            ComboSelectionDialog dialog = new ComboSelectionDialog(this.getShell(), shellTitle, labelText, (String[])keys, initialSelectionIndex);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                Object var9_8 = null;
                this.updateUIElements(preserved);
                return;
            }
            int action = (Integer)stringMapping.get(dialog.getSelectedString());
            PushDownInputPage.setInfoAction(this.getSelectedMemberActionInfos(), action);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.updateUIElements(preserved);
            throw throwable;
        }
        Object var9_10 = null;
        this.updateUIElements(preserved);
    }

    private int getInitialSelectionIndexForEditDialog(Map stringMapping, String[] keys) {
        int commonActionCode = this.getCommonActionCodeForSelectedInfos();
        if (commonActionCode == -1) {
            return 0;
        }
        Iterator iter = stringMapping.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int action = (Integer)stringMapping.get(key);
            if (commonActionCode != action) continue;
            int i = 0;
            while (i < keys.length) {
                if (key.equals(keys[i])) {
                    return i;
                }
                ++i;
            }
            Assert.isTrue(false);
        }
        return 0;
    }

    private int getCommonActionCodeForSelectedInfos() {
        PushDownRefactoring.MemberActionInfo[] infos = this.getSelectedMemberActionInfos();
        if (infos.length == 0) {
            return -1;
        }
        int code = infos[0].getAction();
        int i = 0;
        while (i < infos.length) {
            if (code != infos[i].getAction()) {
                return -1;
            }
            ++i;
        }
        return code;
    }

    private Map createStringMappingForSelectedElements() {
        HashMap result = new HashMap();
        this.addToStringMapping(result, 0);
        this.addToStringMapping(result, 1);
        return result;
    }

    private void addToStringMapping(Map result, int action) {
        result.put(MemberActionInfoLabelProvider.getActionLabel(action), new Integer(action));
    }

    private static void setInfoAction(PushDownRefactoring.MemberActionInfo[] infos, int action) {
        int i = 0;
        while (i < infos.length) {
            infos[i].setAction(action);
            ++i;
        }
    }

    private PushDownRefactoring.MemberActionInfo[] getSelectedMemberActionInfos() {
        Assert.isTrue(this.fTableViewer.getSelection() instanceof IStructuredSelection);
        List result = this.getTableSelection().toList();
        return result.toArray(new PushDownRefactoring.MemberActionInfo[result.size()]);
    }

    private IStructuredSelection getTableSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updateUIElements(ISelection preserved) {
        this.fTableViewer.refresh();
        if (preserved != null) {
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(preserved);
        }
        this.checkPageCompletionStatus();
        this.updateButtonEnablementState(this.getTableSelection());
        this.updateStatusLine();
    }

    private void updateStatusLine() {
        if (this.fStatusLine == null) {
            return;
        }
        int selected = this.fTableViewer.getCheckedElements().length;
        Object[] keys = new String[]{String.valueOf(selected)};
        String msg = RefactoringMessages.getFormattedString("PushDownInputPage.status_line", keys);
        this.fStatusLine.setText(msg);
    }

    private void checkPageCompletionStatus() {
        if (this.areAllElementsMarkedAsNoAction()) {
            this.setErrorMessage(RefactoringMessages.getString("PushDownInputPage.Select_members_to_push_down"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private boolean areAllElementsMarkedAsNoAction() {
        return this.countInfosForAction(2) == this.getTableInputAsMemberActionInfoArray().length;
    }

    private int countInfosForAction(int action) {
        PushDownRefactoring.MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
        int count = 0;
        int i = 0;
        while (i < macs.length) {
            PushDownRefactoring.MemberActionInfo info = macs[i];
            if (info.getAction() == action) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private PushDownRefactoring.MemberActionInfo[] getTableInputAsMemberActionInfoArray() {
        return (PushDownRefactoring.MemberActionInfo[])this.fTableViewer.getInput();
    }

    private void updateButtonEnablementState(IStructuredSelection tableSelection) {
        if (tableSelection == null || this.fEditButton == null) {
            return;
        }
        this.fEditButton.setEnabled(this.enableEditButton(tableSelection));
    }

    private boolean enableEditButton(IStructuredSelection tableSelection) {
        if (tableSelection.isEmpty() || tableSelection.size() == 0) {
            return false;
        }
        return tableSelection.size() == PushDownInputPage.countEditableInfos(this.getSelectedMemberActionInfos());
    }

    private static int countEditableInfos(PushDownRefactoring.MemberActionInfo[] memberActionInfos) {
        int result = 0;
        int i = 0;
        while (i < memberActionInfos.length) {
            if (memberActionInfos[i].isEditable()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private PushDownRefactoring getPushDownRefactoring() {
        return (PushDownRefactoring)this.getRefactoring();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
            this.fTableViewer.getControl().setFocus();
        }
    }

    private class PullUpCellModifier
    implements ICellModifier {
        PullUpCellModifier() {
        }

        public Object getValue(Object element, String property) {
            if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                return null;
            }
            PushDownRefactoring.MemberActionInfo mac = (PushDownRefactoring.MemberActionInfo)element;
            return new Integer(mac.getAction());
        }

        public boolean canModify(Object element, String property) {
            if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                return false;
            }
            return ((PushDownRefactoring.MemberActionInfo)element).isEditable();
        }

        public void modify(Object element, String property, Object value) {
            if (!PushDownInputPage.ACTION_PROPERTY.equals(property)) {
                return;
            }
            int action = (Integer)value;
            PushDownRefactoring.MemberActionInfo mac = element instanceof Item ? (PushDownRefactoring.MemberActionInfo)((Item)element).getData() : (PushDownRefactoring.MemberActionInfo)element;
            mac.setAction(action);
            PushDownInputPage.this.updateUIElements(null);
        }
    }

    private static class MemberActionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

        MemberActionInfoLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            PushDownRefactoring.MemberActionInfo mac = (PushDownRefactoring.MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fJavaElementLabelProvider.getText((Object)mac.getMember());
                }
                case 1: {
                    return MemberActionInfoLabelProvider.getActionLabel(mac);
                }
            }
            Assert.isTrue(false);
            return null;
        }

        static String[] getAvailableActionLabels(PushDownRefactoring.MemberActionInfo mac) {
            int[] actions = mac.getAvailableActions();
            String[] result = new String[actions.length];
            int i = 0;
            while (i < actions.length) {
                result[i] = MemberActionInfoLabelProvider.getActionLabel(actions[i]);
                ++i;
            }
            return result;
        }

        static String getActionLabel(PushDownRefactoring.MemberActionInfo mac) {
            return MemberActionInfoLabelProvider.getActionLabel(mac.getAction());
        }

        static String getActionLabel(int action) {
            switch (action) {
                case 2: {
                    return "";
                }
                case 1: {
                    return RefactoringMessages.getString("PushDownInputPage.leave_abstract");
                }
                case 0: {
                    return RefactoringMessages.getString("PushDownInputPage.push_down");
                }
            }
            Assert.isTrue(false);
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            PushDownRefactoring.MemberActionInfo mac = (PushDownRefactoring.MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fJavaElementLabelProvider.getImage((Object)mac.getMember());
                }
                case 1: {
                    return null;
                }
            }
            Assert.isTrue(false);
            return null;
        }

        public void dispose() {
            super.dispose();
            this.fJavaElementLabelProvider.dispose();
        }
    }
}

