/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class PullUpInputPage1
extends UserInputWizardPage {
    private static final int MEMBER_COLUMN = 0;
    private static final int ACTION_COLUMN = 1;
    private static final int ROW_COUNT = 10;
    public static final String PAGE_NAME = "PullUpMethodsInputPage1";
    private static final String ACTION_PROPERTY = "action";
    private static final String MEMBER_PROPERTY = "member";
    private CheckboxTableViewer fTableViewer;
    private Combo fSuperclassCombo;
    private IType[] fSuperclasses;
    private Button fEditButton;
    private Button fCreateStubsButton;
    private Label fStatusLine;

    public PullUpInputPage1() {
        super(PAGE_NAME, false);
        this.setMessage(RefactoringMessages.getString("PullUpInputPage1.page_message"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        this.createSuperTypeCombo(composite);
        this.createSpacer(composite);
        this.createStubCheckbox(composite);
        this.createSpacer(composite);
        this.createMemberTableLabel(composite);
        this.createMemberTableComposite(composite);
        this.createStatusLine(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.pull_up_wizard_page_context");
    }

    private void createStatusLine(Composite composite) {
        this.fStatusLine = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.updateStatusLine();
        this.fStatusLine.setLayoutData((Object)gd);
    }

    private void createStubCheckbox(Composite parent) {
        this.fCreateStubsButton = new Button(parent, 32);
        this.fCreateStubsButton.setText(RefactoringMessages.getString("PullUpInputPage1.Create_stubs"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fCreateStubsButton.setLayoutData((Object)gd);
        this.fCreateStubsButton.setEnabled(false);
        this.fCreateStubsButton.setSelection(this.getPullUpRefactoring().getCreateMethodStubs());
    }

    private void createSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd0 = new GridData();
        gd0.horizontalSpan = 2;
        label.setLayoutData((Object)gd0);
    }

    private PullUpRefactoring getPullUpRefactoring() {
        return (PullUpRefactoring)this.getRefactoring();
    }

    private void createSuperTypeCombo(final Composite parent) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        try {
                            PullUpInputPage1.this.createSuperTypeCombo(pm, parent);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        pm.done();
                        throw throwable;
                    }
                    Object var3_5 = null;
                    pm.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PullUpInputPage.pull_Up"), RefactoringMessages.getString("PullUpInputPage.exception"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue(false);
        }
    }

    private void createSuperTypeCombo(IProgressMonitor pm, Composite parent) throws JavaModelException {
        Label label = new Label(parent, 0);
        label.setText(RefactoringMessages.getString("PullUpInputPage1.Select_destination"));
        label.setLayoutData((Object)new GridData());
        this.fSuperclassCombo = new Combo(parent, 8);
        this.fSuperclasses = this.getPullUpRefactoring().getPossibleTargetClasses(pm);
        Assert.isTrue(this.fSuperclasses.length > 0);
        int i = 0;
        while (i < this.fSuperclasses.length) {
            String comboLabel = JavaModelUtil.getFullyQualifiedName(this.fSuperclasses[i]);
            this.fSuperclassCombo.add(comboLabel);
            ++i;
        }
        this.fSuperclassCombo.select(this.fSuperclasses.length - 1);
        this.fSuperclassCombo.setLayoutData((Object)new GridData(768));
    }

    private void createMemberTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        this.createMemberTable(composite);
        this.createButtonComposite(composite);
    }

    private void createMemberTableLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(RefactoringMessages.getString("PullUpInputPage1.Specify_actions"));
        GridData gd0 = new GridData();
        gd0.horizontalSpan = 2;
        label.setLayoutData((Object)gd0);
    }

    private void createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        this.fEditButton = new Button(composite, 8);
        this.fEditButton.setText(RefactoringMessages.getString("PullUpInputPage1.Edit"));
        this.fEditButton.setLayoutData((Object)new GridData(768));
        this.fEditButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PullUpInputPage1.this.editSelectedMembers();
            }
        });
        Button addButton = new Button(composite, 8);
        addButton.setText(RefactoringMessages.getString("PullUpInputPage1.Add_Required"));
        addButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PullUpInputPage1.this.markAdditionalRequiredMembersAsMembersToPullUp();
            }
        });
    }

    private void editSelectedMembers() {
        if (!this.fEditButton.isEnabled()) {
            return;
        }
        ISelection preserved = this.fTableViewer.getSelection();
        try {
            String shellTitle = RefactoringMessages.getString("PullUpInputPage1.Edit_members");
            String labelText = RefactoringMessages.getString("PullUpInputPage1.Mark_selected_members");
            Map stringMapping = this.createStringMappingForSelectedMembers();
            Object[] keys = stringMapping.keySet().toArray(new String[stringMapping.keySet().size()]);
            Arrays.sort(keys);
            int initialSelectionIndex = this.getInitialSelectionIndexForEditDialog(stringMapping, (String[])keys);
            ComboSelectionDialog dialog = new ComboSelectionDialog(this.getShell(), shellTitle, labelText, (String[])keys, initialSelectionIndex);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                Object var9_8 = null;
                this.updateUIElements(preserved);
                return;
            }
            int action = (Integer)stringMapping.get(dialog.getSelectedString());
            PullUpInputPage1.setInfoAction(this.getSelectedMemberActionInfos(), action);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.updateUIElements(preserved);
            throw throwable;
        }
        Object var9_10 = null;
        this.updateUIElements(preserved);
    }

    private int getInitialSelectionIndexForEditDialog(Map stringMapping, String[] keys) {
        int commonActionCode = this.getCommonActionCodeForSelectedInfos();
        if (commonActionCode == -1) {
            return 0;
        }
        Iterator iter = stringMapping.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int action = (Integer)stringMapping.get(key);
            if (commonActionCode != action) continue;
            int i = 0;
            while (i < keys.length) {
                if (key.equals(keys[i])) {
                    return i;
                }
                ++i;
            }
            Assert.isTrue(false);
        }
        return 0;
    }

    private int getCommonActionCodeForSelectedInfos() {
        MemberActionInfo[] infos = this.getSelectedMemberActionInfos();
        if (infos.length == 0) {
            return -1;
        }
        int code = infos[0].getAction();
        int i = 0;
        while (i < infos.length) {
            if (code != infos[i].getAction()) {
                return -1;
            }
            ++i;
        }
        return code;
    }

    private static void setInfoAction(MemberActionInfo[] infos, int action) {
        int i = 0;
        while (i < infos.length) {
            infos[i].setAction(action);
            ++i;
        }
    }

    private Map createStringMappingForSelectedMembers() {
        HashMap result = new HashMap();
        PullUpInputPage1.putToStingMapping(result, MemberActionInfo.METHOD_LABELS, 0);
        PullUpInputPage1.putToStingMapping(result, MemberActionInfo.METHOD_LABELS, 1);
        return result;
    }

    private static void putToStingMapping(Map result, String[] actionLabels, int actionIndex) {
        result.put(actionLabels[actionIndex], new Integer(actionIndex));
    }

    private void updateUIElements(ISelection preserved) {
        this.fTableViewer.refresh();
        if (preserved != null) {
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(preserved);
        }
        this.checkPageCompletionStatus();
        this.updateButtonEnablementState(this.fTableViewer.getSelection());
        this.updateStatusLine();
    }

    private void updateStatusLine() {
        if (this.fStatusLine == null) {
            return;
        }
        int selected = this.fTableViewer.getCheckedElements().length;
        Object[] keys = new String[]{String.valueOf(selected)};
        String msg = RefactoringMessages.getFormattedString("PullUpInputPage1.status_line", keys);
        this.fStatusLine.setText(msg);
    }

    private static int countEditableInfos(MemberActionInfo[] infos) {
        int result = 0;
        int i = 0;
        while (i < infos.length) {
            MemberActionInfo info = infos[i];
            if (info.isEditable()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private MemberActionInfo[] getSelectedMemberActionInfos() {
        Assert.isTrue(this.fTableViewer.getSelection() instanceof IStructuredSelection);
        IStructuredSelection ss = (IStructuredSelection)this.fTableViewer.getSelection();
        List result = ss.toList();
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private void markAdditionalRequiredMembersAsMembersToPullUp() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException {
                    try {
                        try {
                            PullUpInputPage1.this.markAsMembersToPullUp(PullUpInputPage1.this.getPullUpRefactoring().getAdditionalRequiredMembersToPullUp(pm));
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        pm.done();
                        throw throwable;
                    }
                    Object var3_5 = null;
                    pm.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PullUpInputPage.pull_Up"), RefactoringMessages.getString("PullUpInputPage.exception"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue(false);
        }
    }

    private void createMemberTable(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        Table table = new Table((Composite)layouter, 67618);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(770);
        gd.heightHint = table.getHeaderHeight() + (table.getGridLineWidth() + table.getItemHeight()) * 10;
        layouter.setLayoutData(gd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setText(RefactoringMessages.getString("PullUpInputPage1.Member"));
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(RefactoringMessages.getString("PullUpInputPage1.Action"));
        this.fTableViewer = new PullPushCheckboxTableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PullUpInputPage1.this.updateButtonEnablementState(event.getSelection());
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                MemberActionInfo info = (MemberActionInfo)event.getElement();
                if (checked) {
                    info.setAction(0);
                } else {
                    info.setAction(2);
                }
                PullUpInputPage1.this.updateUIElements(null);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PullUpInputPage1.this.editSelectedMembers();
            }
        });
        this.setTableInput();
        this.markAsMembersToPullUp(this.getPullUpRefactoring().getMembersToPullUp());
        this.setupCellEditors(table);
    }

    private void updateButtonEnablementState(ISelection tableSelection) {
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.enableEditButton((IStructuredSelection)tableSelection));
        }
        this.fCreateStubsButton.setEnabled(this.getMethodsToDeclareAbstract().length != 0);
    }

    private boolean enableEditButton(IStructuredSelection ss) {
        if (ss.isEmpty() || ss.size() == 0) {
            return false;
        }
        return ss.size() == PullUpInputPage1.countEditableInfos(this.getSelectedMemberActionInfos());
    }

    private void setTableInput() {
        this.fTableViewer.setInput((Object)this.convertPullableMemberToMemberActionInfoArray());
    }

    private MemberActionInfo[] convertPullableMemberToMemberActionInfoArray() {
        List<IMember> toPullUp = Arrays.asList(this.getPullUpRefactoring().getMembersToPullUp());
        IMember[] members = this.getPullUpRefactoring().getPullableMembersOfDeclaringType();
        MemberActionInfo[] result = new MemberActionInfo[members.length];
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            result[i] = toPullUp.contains(member) ? new MemberActionInfo(member, 0) : new MemberActionInfo(member, 2);
            ++i;
        }
        return result;
    }

    private void setupCellEditors(final Table table) {
        final ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor();
        comboBoxCellEditor.setStyle(8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = comboBoxCellEditor;
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel;
                if (comboBoxCellEditor.getControl() == null & !table.isDisposed()) {
                    comboBoxCellEditor.create((Composite)table);
                }
                if (!((sel = event.getSelection()) instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)sel;
                if (ss.size() != 1) {
                    return;
                }
                MemberActionInfo mac = (MemberActionInfo)ss.getFirstElement();
                comboBoxCellEditor.setItems(mac.getAllowedLabels());
                comboBoxCellEditor.setValue((Object)new Integer(mac.getAction()));
            }
        });
        PullUpCellModifier cellModifier = new PullUpCellModifier();
        this.fTableViewer.setCellModifier((ICellModifier)cellModifier);
        this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
    }

    private void checkPageCompletionStatus() {
        if (this.areAllMembersMarkedAsWithNoAction()) {
            this.setErrorMessage(RefactoringMessages.getString("PullUpInputPage1.Select_members_to_pull_up"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private boolean areAllMembersMarkedAsWithNoAction() {
        return this.getMembersWithNoAction().length == this.getTableInputAsMemberActionInfoArray().length;
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        if (this.canSkipSecondInputPage()) {
            return this.getRefactoringWizard().computeUserInputSuccessorPage((IWizardPage)this);
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        if (this.canSkipSecondInputPage()) {
            return this.isPageComplete();
        }
        return super.canFlipToNextPage();
    }

    private boolean canSkipSecondInputPage() {
        return this.getMethodsToPullUp().length == 0;
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        return super.performFinish();
    }

    private void initializeRefactoring() {
        this.getPullUpRefactoring().setMembersToPullUp(this.getMembersToPullUp());
        this.getPullUpRefactoring().setMethodsToDeclareAbstract(this.getMethodsToDeclareAbstract());
        this.getPullUpRefactoring().setTargetClass(this.getSelectedClass());
        this.getPullUpRefactoring().setCreateMethodStubs(this.fCreateStubsButton.getSelection());
        this.getPullUpRefactoring().setMethodsToDelete(this.getMethodsToPullUp());
    }

    private IType getSelectedClass() {
        return this.fSuperclasses[this.fSuperclassCombo.getSelectionIndex()];
    }

    private void markAsMembersToPullUp(IMember[] elements) {
        this.setActionForMembers(elements, 0);
        this.updateUIElements(null);
    }

    private void setActionForMembers(IMember[] members, int action) {
        MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
        int i = 0;
        while (i < members.length) {
            int j = 0;
            while (j < macs.length) {
                if (macs[j].getMember().equals(members[i])) {
                    macs[j].setAction(action);
                }
                ++j;
            }
            ++i;
        }
    }

    private MemberActionInfo[] getTableInputAsMemberActionInfoArray() {
        return (MemberActionInfo[])this.fTableViewer.getInput();
    }

    private IMethod[] getMethodsToPullUp() {
        return this.getMethodsForAction(0);
    }

    private IMethod[] getMethodsToDeclareAbstract() {
        return this.getMethodsForAction(1);
    }

    private IMethod[] getMethodsForAction(int action) {
        MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
        ArrayList<IMember> list = new ArrayList<IMember>(macs.length);
        int i = 0;
        while (i < macs.length) {
            if (macs[i].isMethodInfo() && macs[i].getAction() == action) {
                list.add(macs[i].getMember());
            }
            ++i;
        }
        return list.toArray(new IMethod[list.size()]);
    }

    private IMember[] getMembersWithNoAction() {
        return this.getMembersForAction(2);
    }

    private IMember[] getMembersToPullUp() {
        return this.getMembersForAction(0);
    }

    private IMember[] getMembersForAction(int action) {
        MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
        ArrayList<IMember> result = new ArrayList<IMember>(macs.length);
        int i = 0;
        while (i < macs.length) {
            if (macs[i].getAction() == action) {
                result.add(macs[i].getMember());
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private MemberActionInfo[] getActiveInfos() {
        MemberActionInfo[] infos = this.getTableInputAsMemberActionInfoArray();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(infos.length);
        int i = 0;
        while (i < infos.length) {
            MemberActionInfo info = infos[i];
            if (info.isActive()) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
            this.fTableViewer.getControl().setFocus();
        }
    }

    private class PullUpCellModifier
    implements ICellModifier {
        PullUpCellModifier() {
        }

        public Object getValue(Object element, String property) {
            if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                return null;
            }
            MemberActionInfo mac = (MemberActionInfo)element;
            return new Integer(mac.getAction());
        }

        public boolean canModify(Object element, String property) {
            if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                return false;
            }
            MemberActionInfo mac = (MemberActionInfo)element;
            return mac.isEditable();
        }

        public void modify(Object element, String property, Object value) {
            if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                return;
            }
            int action = (Integer)value;
            MemberActionInfo mac = element instanceof Item ? (MemberActionInfo)((Item)element).getData() : (MemberActionInfo)element;
            if (!this.canModify(mac, property)) {
                return;
            }
            Assert.isTrue(mac.isMethodInfo());
            mac.setAction(action);
            PullUpInputPage1.this.updateUIElements(null);
        }
    }

    private static class MemberActionInfo
    implements IMemberActionInfo {
        static final int PULL_UP_ACTION = 0;
        static final int DECLARE_ABSTRACT_ACTION = 1;
        static final int NO_ACTION = 2;
        private static final String NO_LABEL = "";
        private static final String PULL_UP_LABEL = RefactoringMessages.getString("PullUpInputPage1.pull_up");
        private static final String DECLARE_ABSTRACT_LABEL = RefactoringMessages.getString("PullUpInputPage1.declare_abstract");
        private static final String[] FIELD_LABELS = new String[]{""};
        private static final String[] METHOD_LABELS = new String[2];
        private static final String[] TYPE_LABELS;
        private final IMember fMember;
        private int fAction;

        static {
            MemberActionInfo.METHOD_LABELS[0] = PULL_UP_LABEL;
            MemberActionInfo.METHOD_LABELS[1] = DECLARE_ABSTRACT_LABEL;
            TYPE_LABELS = new String[1];
            MemberActionInfo.TYPE_LABELS[0] = PULL_UP_LABEL;
        }

        MemberActionInfo(IMember member, int action) {
            Assert.isTrue(member instanceof IMethod || member instanceof IField || member instanceof IType);
            MemberActionInfo.assertAction(member, action);
            this.fMember = member;
            this.fAction = action;
        }

        public boolean isTypeInfo() {
            return this.getMember() instanceof IType;
        }

        public boolean isMethodInfo() {
            return this.getMember() instanceof IMethod;
        }

        public boolean isFieldInfo() {
            return this.getMember() instanceof IField;
        }

        IMember getMember() {
            return this.fMember;
        }

        int getAction() {
            return this.fAction;
        }

        private static void assertAction(IMember member, int action) {
            if (member instanceof IMethod) {
                try {
                    Assert.isTrue(action != 1 || !JdtFlags.isStatic(member));
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Assert.isTrue(action == 2 || action == 1 || action == 0);
            } else {
                Assert.isTrue(action == 2 || action == 0);
            }
        }

        void setAction(int action) {
            MemberActionInfo.assertAction(this.fMember, action);
            this.fAction = action;
        }

        String getActionLabel() {
            switch (this.fAction) {
                case 0: {
                    return PULL_UP_LABEL;
                }
                case 1: {
                    return DECLARE_ABSTRACT_LABEL;
                }
                case 2: {
                    return NO_LABEL;
                }
            }
            Assert.isTrue(false);
            return null;
        }

        String[] getAllowedLabels() {
            if (this.isFieldInfo()) {
                return FIELD_LABELS;
            }
            if (this.isMethodInfo()) {
                return METHOD_LABELS;
            }
            if (this.isTypeInfo()) {
                return TYPE_LABELS;
            }
            Assert.isTrue(false);
            return null;
        }

        public boolean isEditable() {
            if (this.fAction == 2) {
                return false;
            }
            if (!this.isMethodInfo()) {
                return false;
            }
            IMethod method = (IMethod)this.fMember;
            try {
                return !JdtFlags.isStatic((IMember)method);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }
    }

    private static class MemberActionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

        MemberActionInfoLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            MemberActionInfo mac = (MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fJavaElementLabelProvider.getText((Object)mac.getMember());
                }
                case 1: {
                    return mac.getActionLabel();
                }
            }
            Assert.isTrue(false);
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            MemberActionInfo mac = (MemberActionInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fJavaElementLabelProvider.getImage((Object)mac.getMember());
                }
                case 1: {
                    return null;
                }
            }
            Assert.isTrue(false);
            return null;
        }

        public void dispose() {
            super.dispose();
            this.fJavaElementLabelProvider.dispose();
        }
    }
}

