/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.jface.util.Assert;

class PseudoJavaChangeElement
extends ChangeElement {
    private IJavaElement fJavaElement;
    private List fChildren;

    public PseudoJavaChangeElement(ChangeElement parent, IJavaElement element) {
        super(parent);
        this.fJavaElement = element;
        Assert.isNotNull((Object)this.fJavaElement);
    }

    public IJavaElement getJavaElement() {
        return this.fJavaElement;
    }

    public void setActive(boolean active) {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            ChangeElement element = (ChangeElement)iter.next();
            element.setActive(active);
        }
    }

    public int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((ChangeElement)this.fChildren.get(0)).getActive();
        int i = 1;
        while (i < this.fChildren.size()) {
            ChangeElement element = (ChangeElement)this.fChildren.get(i);
            result = ChangeElement.ACTIVATION_TABLE[element.getActive()][result];
            if (result == 1) break;
            ++i;
        }
        return result;
    }

    public ChangeElement[] getChildren() {
        if (this.fChildren == null) {
            return ChangeElement.EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new ChangeElement[this.fChildren.size()]);
    }

    public void addChild(TextEditChangeElement child) {
        this.doAddChild(child);
    }

    public void addChild(PseudoJavaChangeElement child) {
        this.doAddChild(child);
    }

    private void doAddChild(ChangeElement child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(child);
    }
}

