/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.jdt.internal.ui.refactoring.ComparePreviewer;
import org.eclipse.jdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.IPreviewViewer;
import org.eclipse.jdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    private IChange fChange;
    private ChangeElement fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    private ChangeElementTreeViewer fTreeViewer;
    private PageBook fPreviewContainer;
    private IPreviewViewer fCurrentPreviewViewer;
    private IPreviewViewer fNullPreviewer;
    private ComparePreviewer fComparePreview;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringMessages.getString("PreviewWizardPage.description"));
    }

    public void setChange(IChange change) {
        if (this.fChange == change) {
            return;
        }
        this.fChange = change;
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite parent) {
        return new ChangeElementTreeViewer(parent);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);
    }

    protected ComparePreviewer.CompareInput getCompareInput(ChangeElement element) {
        try {
            if (element instanceof DefaultChangeElement) {
                IChange change = ((DefaultChangeElement)element).getChange();
                if (change instanceof TextChange) {
                    TextChange cuc = (TextChange)change;
                    String type = "txt";
                    if (change instanceof CompilationUnitChange) {
                        type = "java";
                    }
                    return this.createCompareInput(element, cuc.getCurrentContent(), cuc.getPreviewContent(), type);
                }
                if (change instanceof CreateTextFileChange) {
                    CreateTextFileChange ctfc = (CreateTextFileChange)change;
                    String type = ctfc.isJavaFile() ? "java" : "txt";
                    return this.createCompareInput(element, ctfc.getCurrentContent(), ctfc.getPreview(), type);
                }
            } else {
                PseudoJavaChangeElement pjce;
                List l;
                if (element instanceof TextEditChangeElement) {
                    ISourceReference sourceReference;
                    TextChange.EditChange tec = ((TextEditChangeElement)element).getTextEditChange();
                    TextChange change = tec.getTextChange();
                    if (change instanceof CompilationUnitChange && (sourceReference = this.findSourceReference(element)) != null) {
                        CompilationUnitChange cuc = (CompilationUnitChange)change;
                        return this.createCompareInput(element, cuc.getCurrentContent(sourceReference), cuc.getPreviewContent(sourceReference, new TextChange.EditChange[]{tec}), "java");
                    }
                    return this.createCompareInput(element, change.getCurrentContent(tec, 2), change.getPreviewContent(tec, 2), "txt");
                }
                if (element instanceof PseudoJavaChangeElement && (l = this.collectTextEditChanges(pjce = (PseudoJavaChangeElement)element)).size() > 0) {
                    TextChange.EditChange[] changes = l.toArray(new TextChange.EditChange[l.size()]);
                    CompilationUnitChange change = (CompilationUnitChange)changes[0].getTextChange();
                    ISourceReference sourceReference = (ISourceReference)pjce.getJavaElement();
                    return this.createCompareInput(element, change.getCurrentContent(sourceReference), change.getPreviewContent(sourceReference, changes), "java");
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PreviewWizardPage.showing_preview"), RefactoringMessages.getString("PreviewWizardPage.exception"));
        }
        return null;
    }

    private ComparePreviewer.CompareInput createCompareInput(ChangeElement element, String left, String right, String type) {
        if (element == null || left == null || right == null || type == null) {
            return null;
        }
        return new ComparePreviewer.CompareInput(element, left, right, type);
    }

    protected IPreviewViewer getPreviewer(ChangeElement element, IPreviewViewer currentViewer, Composite parent) {
        ComparePreviewer.CompareInput input = this.getCompareInput(element);
        if (input != null) {
            this.fComparePreview.setInput(input);
            return this.fComparePreview;
        }
        return null;
    }

    protected boolean performFinish() {
        return this.getRefactoringWizard().performFinish(new PerformChangeOperation(this.fChange));
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fPageContainer = new PageBook(parent, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(result, 512);
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setText(RefactoringMessages.getString("PreviewWizardPage.changes"));
        ToolBarManager tbm = pane.getToolBarManager();
        tbm.add((IAction)new NextChange());
        tbm.add((IAction)new PreviousChange());
        tbm.update(true);
        this.fTreeViewer = this.createTreeViewer((Composite)pane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        pane.setContent(this.fTreeViewer.getControl());
        this.setTreeViewerInput();
        this.fPreviewContainer = new PageBook((Composite)sashForm, 0);
        this.fComparePreview = new ComparePreviewer((Composite)this.fPreviewContainer);
        this.fNullPreviewer = new NullPreviewer((Composite)this.fPreviewContainer);
        this.fPreviewContainer.showPage(this.fNullPreviewer.getControl());
        sashForm.setWeights(new int[]{33, 67});
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createNullPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0x1000000);
        label.setText(RefactoringMessages.getString("PreviewWizardPage.no_source_code_change"));
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void setVisible(boolean visible) {
        this.fCurrentSelection = null;
        if (this.hasChanges()) {
            ITreeContentProvider provider;
            Object[] elements;
            IStructuredSelection selection;
            this.fPageContainer.showPage(this.fStandardPage);
            ChangeElement treeViewerInput = (ChangeElement)this.fTreeViewer.getInput();
            if (visible && treeViewerInput != null && (selection = (IStructuredSelection)this.fTreeViewer.getSelection()).isEmpty() && (elements = (provider = (ITreeContentProvider)this.fTreeViewer.getContentProvider()).getElements((Object)treeViewerInput)) != null && elements.length > 0) {
                Object[] subElements;
                Object element = elements[0];
                if (this.getRefactoringWizard().getExpandFirstNode() && (subElements = provider.getElements(element)) != null && subElements.length > 0) {
                    this.fTreeViewer.expandToLevel(element, 999);
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(element));
            }
            super.setVisible(visible);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(visible);
        }
        this.getRefactoringWizard().setPreviewShown(visible);
    }

    private void setTreeViewerInput() {
        DefaultChangeElement input = this.fChange == null ? null : (this.fChange instanceof ICompositeChange && !(this.fChange instanceof TextChange) ? new DefaultChangeElement(null, this.fChange) : new DefaultChangeElement(null, new DummyRootNode(this.fChange)));
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(input);
        }
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangeElement element = (ChangeElement)event.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, element) || this.isChild(element, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(ChangeElement element, ChangeElement child) {
                while (child != null) {
                    if (child == element) {
                        return true;
                    }
                    child = child.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    ChangeElement newSelection = (ChangeElement)sel.getFirstElement();
                    if (newSelection != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = newSelection;
                        PreviewWizardPage.this.showPreview(newSelection);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(ChangeElement element) {
        this.fCurrentPreviewViewer = element != null ? this.getPreviewer(element, this.fCurrentPreviewViewer, (Composite)this.fPreviewContainer) : null;
        if (this.fCurrentPreviewViewer == null) {
            this.fCurrentPreviewViewer = this.fNullPreviewer;
        }
        this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
    }

    private ISourceReference findSourceReference(ChangeElement element) {
        IChange change;
        if (element == null) {
            return null;
        }
        if (element instanceof PseudoJavaChangeElement) {
            return (ISourceReference)((PseudoJavaChangeElement)element).getJavaElement();
        }
        if (element instanceof DefaultChangeElement && (change = ((DefaultChangeElement)element).getChange()) instanceof CompilationUnitChange) {
            return ((CompilationUnitChange)change).getCompilationUnit();
        }
        return this.findSourceReference(element.getParent());
    }

    private List collectTextEditChanges(PseudoJavaChangeElement element) {
        ArrayList<TextChange.EditChange> result = new ArrayList<TextChange.EditChange>(10);
        ChangeElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeElement child = children[i];
            if (child instanceof TextEditChangeElement) {
                result.add(((TextEditChangeElement)child).getTextEditChange());
            } else if (child instanceof PseudoJavaChangeElement) {
                result.addAll(this.collectTextEditChanges((PseudoJavaChangeElement)child));
            }
            ++i;
        }
        return result;
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof ICompositeChange) {
            return ((ICompositeChange)this.fChange).getChildren().length > 0;
        }
        return true;
    }

    private static class DummyRootNode
    extends Change
    implements ICompositeChange {
        private IChange[] fChildren;

        public DummyRootNode(IChange change) {
            this.fChildren = new IChange[]{change};
        }

        public IChange[] getChildren() {
            return this.fChildren;
        }

        public String getName() {
            return null;
        }

        public Object getModifiedLanguageElement() {
            return null;
        }

        public IChange getUndoChange() {
            return null;
        }

        public void perform(ChangeContext context, IProgressMonitor pm) {
        }
    }

    private static class NullPreviewer
    implements IPreviewViewer {
        private Label fLabel;

        public NullPreviewer(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringMessages.getString("PreviewWizardPage.no_preview"));
        }

        public void setInput(Object input) {
        }

        public void refresh() {
        }

        public Control getControl() {
            return this.fLabel;
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.next_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.next_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealNext();
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.previous_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.previous_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealPrevious();
        }
    }
}

