/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;

public class PerformChangeOperation
implements IRunnableWithProgress {
    private IChange fChange;
    private ChangeContext fChangeContext;
    private CreateChangeOperation fCreateChangeOperation;
    private int fCheckPassedSeverity;
    private boolean fChangeExecuted;
    static /* synthetic */ Class class$0;

    public PerformChangeOperation(IChange change) {
        this.fChange = change;
        Assert.isNotNull((Object)this.fChange);
    }

    public PerformChangeOperation(CreateChangeOperation op) {
        this.fCreateChangeOperation = op;
        Assert.isNotNull((Object)this.fCreateChangeOperation);
        this.fCheckPassedSeverity = 1;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public IChange getChange() {
        return this.fChange;
    }

    public RefactoringStatus getStatus() {
        return this.fCreateChangeOperation != null ? this.fCreateChangeOperation.getStatus() : null;
    }

    public void setCheckPassedSeverity(int severity) {
        this.fCheckPassedSeverity = severity;
        Assert.isTrue((this.fCheckPassedSeverity < 4 ? 1 : 0) != 0);
    }

    public void setChangeContext(ChangeContext context) {
        this.fChangeContext = context;
        Assert.isNotNull((Object)this.fChangeContext);
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.fChangeExecuted = false;
                if (this.createChange()) {
                    pm.beginTask("", 2);
                    this.fCreateChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                    this.fChange = this.fCreateChangeOperation.getChange();
                    RefactoringStatus status = this.fCreateChangeOperation.getStatus();
                    int conditionCheckingStyle = this.fCreateChangeOperation.getConditionCheckingStyle();
                    if (this.fChange != null && (conditionCheckingStyle == 0 || status != null && status.getSeverity() <= this.fCheckPassedSeverity)) {
                        this.executeChange((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                        this.fChangeExecuted = true;
                    } else {
                        pm.worked(1);
                    }
                } else {
                    this.executeChange(pm);
                    this.fChangeExecuted = true;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        Object var4_7 = null;
        pm.done();
    }

    private void executeChange(IProgressMonitor pm) throws CoreException {
        block3: {
            Assert.isNotNull((Object)this.fChangeContext);
            IRewriteTarget[] targets = null;
            try {
                targets = PerformChangeOperation.getRewriteTargets();
                PerformChangeOperation.beginCompoundChange(targets);
                this.fChange.aboutToPerform(this.fChangeContext, (IProgressMonitor)new NullProgressMonitor());
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            PerformChangeOperation.this.fChange.perform(PerformChangeOperation.this.fChangeContext, monitor);
                        }
                        catch (ChangeAbortException e) {
                            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10004, RefactoringMessages.getString("PerformChangeOperation.unrecoverable_error"), (Throwable)e));
                        }
                    }
                };
                JavaCore.run((IWorkspaceRunnable)runnable, (IProgressMonitor)pm);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.fChange.performed();
                if (targets != null) {
                    PerformChangeOperation.endCompoundChange(targets);
                }
                throw throwable;
            }
            Object var4_6 = null;
            this.fChange.performed();
            if (targets == null) break block3;
            PerformChangeOperation.endCompoundChange(targets);
        }
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }

    private static void beginCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].beginCompoundChange();
            ++i;
        }
    }

    private static void endCompoundChange(IRewriteTarget[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].endCompoundChange();
            ++i;
        }
    }

    private static IRewriteTarget[] getRewriteTargets() {
        IEditorPart[] editors = JavaPlugin.getInstanciatedEditors();
        ArrayList<IRewriteTarget> result = new ArrayList<IRewriteTarget>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IRewriteTarget target;
            IEditorPart iEditorPart = editors[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)iEditorPart.getAdapter((Class)clazz)) != null) {
                result.add(target);
            }
            ++i;
        }
        return result.toArray(new IRewriteTarget[result.size()]);
    }
}

