/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditDialog
extends StatusDialog {
    private ParameterInfo fParameter;
    private boolean fEditType;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;

    public ParameterEditDialog(Shell parentShell, ParameterInfo parameter, boolean type) {
        super(parentShell);
        this.fParameter = parameter;
        this.fEditType = type;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.onlyNameEdit()) {
            newShell.setText(RefactoringMessages.getString("ParameterEditDialog.name.title"));
        } else {
            newShell.setText(RefactoringMessages.getFormattedString("ParameterEditDialog.all.title", this.fParameter.getNewName()));
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd;
        Label label;
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        if (this.fEditType) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ParameterEditDialog.all.type"));
            this.fType = new Text(result, 2048);
            gd = new GridData(768);
            this.fType.setLayoutData((Object)gd);
            this.fType.setText(this.fParameter.getNewTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
        }
        label = new Label(result, 0);
        this.fName = new Text(result, 2048);
        this.initializeDialogUnits((Control)this.fName);
        if (this.onlyNameEdit()) {
            label.setText(RefactoringMessages.getFormattedString("ParameterEditDialog.name.message", this.fParameter.getNewName()));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            gd = new GridData(768);
            gd.widthHint = this.convertWidthInCharsToPixels(45);
            gd.horizontalSpan = 2;
            this.fName.setLayoutData((Object)gd);
        } else {
            label.setText(RefactoringMessages.getString("ParameterEditDialog.all.name"));
            gd = new GridData(768);
            gd.widthHint = this.convertWidthInCharsToPixels(45);
            this.fName.setLayoutData((Object)gd);
        }
        this.fName.setText(this.fParameter.getNewName());
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditDialog.this.validate((Text)e.widget);
            }
        });
        if (this.fParameter.isAdded()) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ParameterEditDialog.all.defaultValue"));
            this.fDefaultValue = new Text(result, 2048);
            gd = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gd);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
        }
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setNewTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        super.okPressed();
    }

    private void validate(Text first) {
        IStatus[] result = new IStatus[3];
        if (first == this.fType) {
            result[0] = this.validateType();
            result[1] = this.validateName();
            result[2] = this.validateDefaltValue();
        } else if (first == this.fName) {
            result[0] = this.validateName();
            result[1] = this.validateType();
            result[2] = this.validateDefaltValue();
        } else {
            result[0] = this.validateDefaltValue();
            result[1] = this.validateName();
            result[2] = this.validateType();
        }
        int i = 0;
        while (i < result.length) {
            IStatus status = result[i];
            if (status != null && !status.isOK()) {
                this.updateStatus(status);
                return;
            }
            ++i;
        }
        this.updateStatus((IStatus)this.createOkStatus());
    }

    private IStatus validateType() {
        if (this.fType == null) {
            return null;
        }
        String typeName = this.fType.getText();
        if (typeName.length() == 0) {
            return new Status(4, JavaPlugin.getPluginId(), 4, RefactoringMessages.getString("ParameterEditDialog.all.type.error"), null);
        }
        if (PrimitiveType.toCode((String)typeName) != null) {
            return this.createOkStatus();
        }
        return JavaConventions.validateJavaTypeName((String)typeName);
    }

    private IStatus validateName() {
        if (this.fName == null) {
            return null;
        }
        String text = this.fName.getText();
        if (text.length() == 0) {
            return new Status(4, JavaPlugin.getPluginId(), 4, RefactoringMessages.getString("ParameterEditDialog.all.name.error"), null);
        }
        return JavaConventions.validateFieldName((String)text);
    }

    private IStatus validateDefaltValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String s = this.fDefaultValue.getText();
        if (s.length() == 0) {
            return new Status(4, JavaPlugin.getPluginId(), 4, RefactoringMessages.getString("ParameterEditDialog.all.defaultValue.error"), null);
        }
        return this.createOkStatus();
    }

    private boolean onlyNameEdit() {
        return !this.fEditType && !this.fParameter.isAdded();
    }

    private Status createOkStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }
}

