/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

class MoveMembersInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "MoveMembersInputPage";
    private Text fTextField;

    public MoveMembersInputPage() {
        super(PAGE_NAME, true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String message = RefactoringMessages.getFormattedString("MoveMembersInputPage.descriptionKey", new String[]{new Integer(this.getMoveRefactoring().getMovedMembers().length).toString(), JavaModelUtil.getFullyQualifiedName(this.getMoveRefactoring().getDeclaringType())});
            this.setDescription(message);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText(RefactoringMessages.getString("MoveMembersInputPage.destination"));
        label.setLayoutData((Object)new GridData());
        this.addTextField(composite);
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.getString("MoveMembersInputPage.browse"));
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoveMembersInputPage.this.openTypeSelectionDialog();
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.move_members_wizard_page_context");
    }

    public void addTextField(Composite composite) {
        this.fTextField = new Text(composite, 2052);
        this.fTextField.setFocus();
        this.fTextField.setLayoutData((Object)new GridData(768));
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = JavaConventions.validateJavaTypeName((String)MoveMembersInputPage.this.fTextField.getText());
                if (status.getSeverity() == 4) {
                    this.error(status.getMessage());
                } else {
                    try {
                        IType resolvedType = MoveMembersInputPage.this.getMoveRefactoring().getDeclaringType().getJavaProject().findType(MoveMembersInputPage.this.fTextField.getText());
                        IStatus validationStatus = MoveMembersInputPage.validateDestinationType(resolvedType, MoveMembersInputPage.this.fTextField.getText());
                        if (validationStatus.isOK()) {
                            MoveMembersInputPage.this.setErrorMessage(null);
                            MoveMembersInputPage.this.setPageComplete(true);
                        } else {
                            this.error(validationStatus.getMessage());
                        }
                    }
                    catch (JavaModelException ex) {
                        JavaPlugin.log(ex);
                        this.error(RefactoringMessages.getString("MoveMembersInputPage.invalid_name"));
                    }
                }
            }

            private void error(String message) {
                MoveMembersInputPage.this.setErrorMessage(message);
                MoveMembersInputPage.this.setPageComplete(false);
            }
        });
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        return super.getNextPage();
    }

    private void initializeRefactoring() {
        try {
            this.getMoveRefactoring().setDestinationTypeFullyQualifiedName(this.fTextField.getText());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.getString("MoveMembersInputPage.move_Member"), RefactoringMessages.getString("MoveMembersInputPage.exception"));
        }
    }

    private IJavaSearchScope createWorkspaceSourceScope() {
        try {
            return RefactoringScopeFactory.create((IJavaElement)this.getMoveRefactoring().getDeclaringType().getJavaProject());
        }
        catch (JavaModelException e) {
            String title = RefactoringMessages.getString("MoveMembersInputPage.move");
            String message = RefactoringMessages.getString("MoveMembersInputPage.internal_error");
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getMoveRefactoring().getDeclaringType().getJavaProject()}, (boolean)true);
        }
    }

    private void openTypeSelectionDialog() {
        int elementKinds = 0;
        final IJavaSearchScope scope = this.createWorkspaceSourceScope();
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), elementKinds, scope);
        dialog.setTitle(RefactoringMessages.getString("MoveMembersInputPage.choose_Type"));
        dialog.setMessage(RefactoringMessages.getString("MoveMembersInputPage.dialogMessage"));
        dialog.setUpperListLabel(RefactoringMessages.getString("MoveMembersInputPage.upperListLabel"));
        dialog.setLowerListLabel(RefactoringMessages.getString("MoveMembersInputPage.lowerListLabel"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Assert.isTrue(selection.length <= 1);
                if (selection.length == 0) {
                    return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.Invalid_selection"), null);
                }
                Object element = selection[0];
                if (!(element instanceof TypeInfo)) {
                    return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.Invalid_selection"), null);
                }
                try {
                    TypeInfo info = (TypeInfo)element;
                    return MoveMembersInputPage.validateDestinationType(info.resolveType(scope), info.getTypeName());
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.internal_error"), null);
                }
            }
        });
        dialog.setMatchEmptyString(false);
        dialog.setFilter(this.createInitialFilter());
        if (dialog.open() == 1) {
            return;
        }
        IType firstResult = (IType)dialog.getFirstResult();
        this.fTextField.setText(JavaModelUtil.getFullyQualifiedName(firstResult));
    }

    private String createInitialFilter() {
        if (!this.fTextField.getText().trim().equals("")) {
            return this.fTextField.getText();
        }
        return RefactoringMessages.getString("MoveMembersInputPage.initialFiler");
    }

    private static IStatus validateDestinationType(IType type, String typeName) {
        if (type == null || !type.exists()) {
            return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getFormattedString("MoveMembersInputPage.not_found", typeName), null);
        }
        if (type.isBinary()) {
            return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.getString("MoveMembersInputPage.no_binary"), null);
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private MoveStaticMembersRefactoring getMoveRefactoring() {
        return (MoveStaticMembersRefactoring)this.getRefactoring();
    }
}

