/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ExtractInterfaceInputPage
extends TextInputWizardPage {
    private Button fReplaceAllCheckbox;
    private CheckboxTableViewer fTableViewer;
    private static final String DESCRIPTION = RefactoringMessages.getString("ExtractInterfaceInputPage.description");

    public ExtractInterfaceInputPage() {
        super(DESCRIPTION, true);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 8;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(RefactoringMessages.getString("ExtractInterfaceInputPage.Interface_name"));
        Text text = this.createTextInputField(result);
        text.selectAll();
        text.setLayoutData((Object)new GridData(768));
        this.addReplaceAllCheckbox(result);
        Label separator = new Label(result, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Label tableLabel = new Label(result, 0);
        tableLabel.setText(RefactoringMessages.getString("ExtractInterfaceInputPage.Members"));
        tableLabel.setEnabled(this.anyMembersToExtract());
        gd = new GridData();
        gd.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        this.addMemberListComposite(result);
    }

    private void addMemberListComposite(Composite result) {
        Composite composite = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        try {
            this.fTableViewer.setInput((Object)this.getExtractInterfaceRefactoring().getExtractableMembers());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ExtractInterfaceInputPage.Extract_Interface"), RefactoringMessages.getString("ExtractInterfaceInputPage.Internal_Error"));
            this.fTableViewer.setInput((Object)new IMember[0]);
        }
        this.fTableViewer.getControl().setEnabled(this.anyMembersToExtract());
        this.createButtonComposite(composite);
    }

    private ILabelProvider createLabelProvider() {
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(1090519561, 1);
        return new DecoratingJavaLabelProvider(lprovider);
    }

    private void createButtonComposite(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        GridData gd = new GridData(1040);
        buttonComposite.setLayoutData((Object)gd);
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(RefactoringMessages.getString("ExtractInterfaceInputPage.Select_All"));
        selectAll.setEnabled(this.anyMembersToExtract());
        selectAll.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractInterfaceInputPage.this.fTableViewer.setAllChecked(true);
            }
        });
        Button deSelectAll = new Button(buttonComposite, 8);
        deSelectAll.setText(RefactoringMessages.getString("ExtractInterfaceInputPage.Deselect_All"));
        deSelectAll.setEnabled(this.anyMembersToExtract());
        deSelectAll.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deSelectAll);
        deSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractInterfaceInputPage.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private boolean anyMembersToExtract() {
        try {
            return this.getExtractInterfaceRefactoring().getExtractableMembers().length > 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void addReplaceAllCheckbox(Composite result) {
        Object[] keys = new String[]{this.getExtractInterfaceRefactoring().getInputType().getElementName()};
        String title = RefactoringMessages.getFormattedString("ExtractInterfaceInputPage.change_references", keys);
        boolean defaultValue = this.getExtractInterfaceRefactoring().isReplaceOccurrences();
        this.fReplaceAllCheckbox = ExtractInterfaceInputPage.createCheckbox(result, title, defaultValue);
        this.getExtractInterfaceRefactoring().setReplaceOccurrences(this.fReplaceAllCheckbox.getSelection());
        this.fReplaceAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractInterfaceInputPage.this.getExtractInterfaceRefactoring().setReplaceOccurrences(ExtractInterfaceInputPage.this.fReplaceAllCheckbox.getSelection());
            }
        });
    }

    private static Button createCheckbox(Composite parent, String title, boolean value) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        checkBox.setLayoutData((Object)layoutData);
        return checkBox;
    }

    protected RefactoringStatus validateTextField(String text) {
        this.getExtractInterfaceRefactoring().setNewInterfaceName(text);
        return this.getExtractInterfaceRefactoring().checkNewInterfaceName(text);
    }

    private ExtractInterfaceRefactoring getExtractInterfaceRefactoring() {
        return (ExtractInterfaceRefactoring)this.getRefactoring();
    }

    public IWizardPage getNextPage() {
        try {
            this.initializeRefactoring();
            return super.getNextPage();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public boolean performFinish() {
        try {
            this.initializeRefactoring();
            return super.performFinish();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private void initializeRefactoring() throws JavaModelException {
        this.getExtractInterfaceRefactoring().setNewInterfaceName(this.getText());
        this.getExtractInterfaceRefactoring().setReplaceOccurrences(this.fReplaceAllCheckbox.getSelection());
        List<Object> checked = Arrays.asList(this.fTableViewer.getCheckedElements());
        this.getExtractInterfaceRefactoring().setExtractedMembers(checked.toArray(new IMember[checked.size()]));
    }

    public void dispose() {
        this.fReplaceAllCheckbox = null;
        this.fTableViewer = null;
        super.dispose();
    }
}

