/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringStatusViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

class ErrorWizardPage
extends RefactoringWizardPage {
    public static final String PAGE_NAME = "ErrorPage";
    private RefactoringStatus fStatus;
    private RefactoringStatusViewer fViewer;
    private final String fHelpContextID;

    public ErrorWizardPage(String helpContextId) {
        super(PAGE_NAME);
        this.fHelpContextID = helpContextId;
    }

    public void setStatus(RefactoringStatus status) {
        this.fStatus = status;
        if (this.fStatus != null) {
            this.setPageComplete(this.isRefactoringPossible());
            int severity = this.fStatus.getSeverity();
            if (severity >= 4) {
                this.setDescription(RefactoringMessages.getString("ErrorWizardPage.cannot_proceed"));
            } else if (severity >= 1) {
                this.setDescription(RefactoringMessages.getString("ErrorWizardPage.confirm"));
            } else {
                this.setDescription("");
            }
        } else {
            this.setPageComplete(true);
            this.setDescription("");
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fViewer = new RefactoringStatusViewer(parent, 0);
        this.setControl((Control)this.fViewer);
        Dialog.applyDialogFont((Control)this.fViewer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)this.fHelpContextID);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fViewer.setStatus(this.fStatus);
        }
        super.setVisible(visible);
    }

    public boolean canFlipToNextPage() {
        return this.fStatus != null && this.isRefactoringPossible() && this.isPageComplete() && super.getNextPage() != null;
    }

    public IWizardPage getNextPage() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        IChange change = wizard.getChange();
        if (change == null) {
            change = wizard.createChange(0, 3, false);
            wizard.setChange(change);
        }
        if (change == null) {
            return this;
        }
        return super.getNextPage();
    }

    protected boolean performFinish() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        IChange change = wizard.getChange();
        PerformChangeOperation op = null;
        if (change != null) {
            op = new PerformChangeOperation(change);
        } else {
            CreateChangeOperation ccop = new CreateChangeOperation(this.getRefactoring(), 0);
            ccop.setCheckPassedSeverity(3);
            op = new PerformChangeOperation(ccop);
            op.setCheckPassedSeverity(3);
        }
        return wizard.performFinish(op);
    }

    private boolean isRefactoringPossible() {
        return this.fStatus.getSeverity() < 4;
    }
}

