/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;

public class CreateChangeOperation
implements IRunnableWithProgress {
    private Refactoring fRefactoring;
    private int fStyle;
    private int fCheckPassedSeverity;
    private IChange fChange;
    private RefactoringStatus fStatus;
    public static final int CHECK_NONE = 0;
    public static final int CHECK_ACTIVATION = 2;
    public static final int CHECK_INPUT = 4;
    public static final int CHECK_PRECONDITION = 6;
    private static final int LAST = 8;

    public CreateChangeOperation(Refactoring refactoring, int style) {
        Assert.isNotNull((Object)refactoring);
        this.fRefactoring = refactoring;
        this.fStyle = style;
        Assert.isTrue((boolean)this.checkStyle(this.fStyle));
        this.fCheckPassedSeverity = 3;
    }

    public CreateChangeOperation(Refactoring refactoring, int style, int checkPassedSeverity) {
        Assert.isNotNull((Object)refactoring);
        this.fRefactoring = refactoring;
        this.fStyle = style;
        Assert.isTrue((boolean)this.checkStyle(this.fStyle));
        this.setCheckPassedSeverity(checkPassedSeverity);
    }

    public void setCheckPassedSeverity(int severity) {
        this.fCheckPassedSeverity = severity;
        Assert.isTrue((this.fCheckPassedSeverity < 4 ? 1 : 0) != 0);
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException {
        this.fChange = null;
        this.fStatus = null;
        try {
            try {
                this.fChange = null;
                if (this.fStyle != 0) {
                    pm.beginTask("", 5);
                    pm.subTask("");
                    CheckConditionsOperation op = new CheckConditionsOperation(this.fRefactoring, this.fStyle);
                    op.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                    this.fStatus = op.getStatus();
                    if (this.fStatus != null && this.fStatus.getSeverity() <= this.fCheckPassedSeverity) {
                        this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                    } else {
                        pm.worked(1);
                    }
                } else {
                    this.fChange = this.fRefactoring.createChange(pm);
                }
            }
            catch (JavaModelException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        Object var3_6 = null;
        pm.done();
    }

    public IChange getChange() {
        return this.fChange;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public int getConditionCheckingStyle() {
        return this.fStyle;
    }

    public void setConditionCheckingStyle(int style) {
        Assert.isTrue((boolean)this.checkStyle(style));
        this.fStyle = style;
    }

    private boolean checkStyle(int style) {
        return style < 8;
    }
}

