/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.VisibilityControlUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

class ConvertAnonymousToNestedInputPage
extends UserInputWizardPage {
    private static final String DESCRIPTION = RefactoringMessages.getString("ConvertAnonymousToNestedInputPage.description");
    public static final String PAGE_NAME = "ConvertAnonymousToNestedInputPage";

    public ConvertAnonymousToNestedInputPage() {
        super(PAGE_NAME, true);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 8;
        result.setLayout((Layout)layout);
        this.addVisibilityControl(result);
        Text textField = this.addFieldNameField(result);
        this.addDeclareFinalCheckbox(result);
        textField.setFocus();
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)result);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.convert_anonymous_to_nested_page_context");
    }

    private Text addFieldNameField(Composite result) {
        Label nameLabel = new Label(result, 0);
        nameLabel.setText(RefactoringMessages.getString("ConvertAnonymousToNestedInputPage.class_name"));
        nameLabel.setLayoutData((Object)new GridData());
        final Text classNameField = new Text(result, 2052);
        classNameField.setLayoutData((Object)new GridData(768));
        classNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConvertAnonymousToNestedInputPage.this.getConvertRefactoring().setClassName(classNameField.getText());
                ConvertAnonymousToNestedInputPage.this.updateStatus();
            }
        });
        return classNameField;
    }

    private void updateStatus() {
        this.setPageComplete(this.getConvertRefactoring().validateInput());
    }

    private void addVisibilityControl(Composite result) {
        int[] availableVisibilities = this.getConvertRefactoring().getAvailableVisibilities();
        int currectVisibility = this.getConvertRefactoring().getVisibility();
        IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

            public void visibilityChanged(int newVisibility) {
                ConvertAnonymousToNestedInputPage.this.getConvertRefactoring().setVisibility(newVisibility);
            }
        };
        Composite visibilityComposite = VisibilityControlUtil.createVisibilityControl(result, visibilityChangeListener, availableVisibilities, currectVisibility);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        visibilityComposite.setLayoutData((Object)gd);
    }

    public void addDeclareFinalCheckbox(Composite result) {
        final Button declareFinalCheckbox = new Button(result, 32);
        declareFinalCheckbox.setEnabled(this.getConvertRefactoring().canEnableSettingFinal());
        declareFinalCheckbox.setSelection(this.getConvertRefactoring().getDeclareFinal());
        declareFinalCheckbox.setText(RefactoringMessages.getString("ConvertAnonymousToNestedInputPage.declare_final"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        declareFinalCheckbox.setLayoutData((Object)gd);
        declareFinalCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertAnonymousToNestedInputPage.this.getConvertRefactoring().setDeclareFinal(declareFinalCheckbox.getSelection());
            }
        });
    }

    private ConvertAnonymousToNestedRefactoring getConvertRefactoring() {
        return (ConvertAnonymousToNestedRefactoring)this.getRefactoring();
    }
}

