/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.VisibilityControlUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

class ChangeSignatureInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ChangeSignatureInputPage";
    private Label fSignaturePreview;

    public ChangeSignatureInputPage() {
        super(PAGE_NAME, true);
        this.setMessage(RefactoringMessages.getString("ChangeSignatureInputPage.new_order"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        try {
            int[] availableVisibilities = this.getChangeMethodSignatureRefactoring().getAvailableVisibilities();
            int currectVisibility = this.getChangeMethodSignatureRefactoring().getVisibility();
            IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

                public void visibilityChanged(int newVisibility) {
                    ChangeSignatureInputPage.this.getChangeMethodSignatureRefactoring().setVisibility(newVisibility);
                    ChangeSignatureInputPage.this.update(true);
                }
            };
            Composite visibilityComposite = VisibilityControlUtil.createVisibilityControl(composite, visibilityChangeListener, availableVisibilities, currectVisibility);
            if (visibilityComposite != null) {
                visibilityComposite.setLayoutData((Object)new GridData(768));
            }
            if (this.getChangeMethodSignatureRefactoring().canChangeReturnType()) {
                this.createReturnTypeControl(composite);
            }
            this.createParameterTableComposite(composite);
            Label label = new Label(composite, 258);
            label.setLayoutData((Object)new GridData(768));
            this.fSignaturePreview = new Label(composite, 64);
            GridData gl = new GridData(1808);
            gl.widthHint = this.convertWidthInCharsToPixels(50);
            this.fSignaturePreview.setLayoutData((Object)gl);
            this.update(false);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ChangeSignatureInputPage.Change_Signature"), RefactoringMessages.getString("ChangeSignatureInputPage.Internal_Error"));
        }
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.modify_parameters_wizard_page_context");
    }

    private void createReturnTypeControl(Composite parent) throws JavaModelException {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(RefactoringMessages.getString("ChangeSignatureInputPage.return_type"));
        label.setLayoutData((Object)new GridData());
        final Text text = new Text(composite, 2048);
        text.setText(this.getChangeMethodSignatureRefactoring().getReturnTypeString());
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeSignatureInputPage.this.getChangeMethodSignatureRefactoring().setNewReturnTypeName(text.getText());
                ChangeSignatureInputPage.this.update(true);
            }
        });
    }

    private void createParameterTableComposite(Composite composite) {
        String labelText = RefactoringMessages.getString("ChangeSignatureInputPage.parameters");
        ChangeParametersControl cp = new ChangeParametersControl(composite, 0, labelText, new IParameterListChangeListener(){

            public void parameterChanged(ParameterInfo parameter) {
                ChangeSignatureInputPage.this.update(true);
            }

            public void parameterListChanged() {
                ChangeSignatureInputPage.this.update(true);
            }

            public void parameterAdded(ParameterInfo parameter) {
                ChangeSignatureInputPage.this.getChangeMethodSignatureRefactoring().setupNewParameterInfo(parameter);
                ChangeSignatureInputPage.this.update(true);
            }
        }, true, true, true);
        cp.setLayoutData(new GridData(768));
        cp.setInput(this.getChangeMethodSignatureRefactoring().getParameterInfos());
    }

    private ChangeSignatureRefactoring getChangeMethodSignatureRefactoring() {
        return (ChangeSignatureRefactoring)this.getRefactoring();
    }

    private void update(boolean displayErrorMessage) {
        this.updateStatus(displayErrorMessage);
        this.updateSignaturePreview();
    }

    private void updateStatus(boolean displayErrorMessage) {
        try {
            if (this.getChangeMethodSignatureRefactoring().isSignatureSameAsInitial()) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            RefactoringStatus nameCheck = this.getChangeMethodSignatureRefactoring().checkSignature();
            if (nameCheck.hasFatalError()) {
                if (displayErrorMessage) {
                    this.setErrorMessage(nameCheck.getFirstMessage(4));
                }
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }
        catch (JavaModelException e) {
            this.setErrorMessage(RefactoringMessages.getString("ChangeSignatureInputPage.Internal_Error"));
            this.setPageComplete(false);
            JavaPlugin.log(e);
        }
    }

    private void updateSignaturePreview() {
        try {
            this.fSignaturePreview.setText(String.valueOf(RefactoringMessages.getString("ChangeSignatureInputPage.method_Signature_Preview")) + this.getChangeMethodSignatureRefactoring().getMethodSignaturePreview());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ChangeSignatureRefactoring.modify_Parameters"), RefactoringMessages.getString("ChangeSignatureInputPage.exception"));
        }
    }
}

