/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.ParameterEditDialog;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ChangeParametersControl
extends Composite {
    private static final String[] PROPERTIES = new String[]{"type", "new", "default"};
    private static final int TYPE_PROP = 0;
    private static final int NEWNAME_PROP = 1;
    private static final int DEFAULT_PROP = 2;
    private static final int ROW_COUNT = 10;
    private final boolean fCanChangeParameterNames;
    private final boolean fCanChangeTypesOfOldParameters;
    private final boolean fCanAddParameters;
    private final IParameterListChangeListener fListener;
    private Button fUpButton;
    private Button fDownButton;
    private TableViewer fTableViewer;
    private Button fEditButton;
    private Button fAddButton;
    private Button fRemoveButton;
    private List fParameterInfos;
    private TableCursor fTableCursor;

    public ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, boolean canChangeParameterNames, boolean canChangeTypesOfOldParameters, boolean canAddParameters) {
        super(parent, style);
        Assert.isNotNull(listener);
        this.fListener = listener;
        this.fCanChangeParameterNames = canChangeParameterNames;
        this.fCanChangeTypesOfOldParameters = canChangeTypesOfOldParameters;
        this.fCanAddParameters = canAddParameters;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label tableLabel = new Label((Composite)this, 0);
        GridData labelGd = new GridData();
        labelGd.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)labelGd);
        tableLabel.setText(label);
        this.createParameterList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List parameterInfos) {
        Assert.isNotNull(parameterInfos);
        this.fParameterInfos = parameterInfos;
        this.fTableViewer.setInput((Object)this.fParameterInfos);
        if (this.fParameterInfos.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fParameterInfos.get(0)));
        }
        if (this.canEditTableCells() && this.getTableItemCount() != 0) {
            this.showTableCursor(true);
        }
    }

    private void createParameterList(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layouter);
        Table table = new Table((Composite)layouter, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setResizable(true);
        tc.setText(RefactoringMessages.getString("ChangeParametersControl.table.type"));
        tc = new TableColumn(table, 0, 1);
        tc.setResizable(true);
        tc.setText(RefactoringMessages.getString("ChangeParametersControl.table.name"));
        if (this.fCanAddParameters) {
            tc = new TableColumn(table, 0, 2);
            tc.setResizable(true);
            tc.setText(RefactoringMessages.getString("ChangeParametersControl.table.defaultValue"));
        }
        GridData gd = new GridData(768);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 10);
        gd.widthHint = 40;
        gd.verticalAlignment = 1;
        gd.grabExcessVerticalSpace = true;
        layouter.setLayoutData(gd);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ParameterInfoContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ParameterInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        if (this.canEditTableCells()) {
            this.addCellEditors();
        }
    }

    private boolean canEditTableCells() {
        return this.fCanChangeParameterNames || this.fCanChangeTypesOfOldParameters;
    }

    private void addTableCursor(final Table table) {
        this.fTableCursor = new TableCursor(table, 0);
        this.fTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeParametersControl.this.fTableViewer.setSelection((ISelection)new StructuredSelection(ChangeParametersControl.this.fTableCursor.getRow().getData()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChangeParametersControl.this.editFirstSelected();
            }
        });
        this.fTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ChangeParametersControl.this.editFirstSelected();
            }

            public void mouseDown(MouseEvent e) {
                ChangeParametersControl.this.editFirstSelected();
            }
        });
        this.fTableCursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 || e.keyCode == SWT.MOD2 || (e.stateMask & SWT.MOD1) != 0 || (e.stateMask & SWT.MOD2) != 0) {
                    ChangeParametersControl.this.setTableCursorVisible(false);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 && (e.stateMask & SWT.MOD2) != 0) {
                    return;
                }
                if (e.keyCode == SWT.MOD2 && (e.stateMask & SWT.MOD1) != 0) {
                    return;
                }
                if (e.keyCode != SWT.MOD1 && (e.stateMask & SWT.MOD1) != 0) {
                    return;
                }
                if (e.keyCode != SWT.MOD2 && (e.stateMask & SWT.MOD2) != 0) {
                    return;
                }
                if (table.getSelectionCount() != 1) {
                    return;
                }
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                ChangeParametersControl.this.fTableCursor.setSelection(row, 0);
                ChangeParametersControl.this.setTableCursorVisible(true);
                ChangeParametersControl.this.fTableCursor.setFocus();
            }
        });
    }

    private void editFirstSelected() {
        ParameterInfo[] selected = this.getSelectedItems();
        if (selected.length != 1) {
            return;
        }
        this.fTableViewer.editElement((Object)selected[0], this.fTableCursor.getColumn());
    }

    private void addColumnLayoutData(TableLayoutComposite layouter) {
        if (this.fCanAddParameters) {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(33, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(33, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(34, true));
        } else {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }
    }

    private ParameterInfo[] getSelectedItems() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection == null) {
            return new ParameterInfo[0];
        }
        if (!(selection instanceof IStructuredSelection)) {
            return new ParameterInfo[0];
        }
        List selected = ((IStructuredSelection)selection).toList();
        return selected.toArray(new ParameterInfo[selected.size()]);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        if (this.fCanAddParameters) {
            this.fAddButton = this.createAddButton(buttonComposite);
        }
        if (this.fCanChangeParameterNames) {
            this.fEditButton = this.createEditButton(buttonComposite);
        }
        if (buttonComposite.getChildren().length != 0) {
            this.addSpacer(buttonComposite);
        }
        this.fUpButton = this.createButton(buttonComposite, RefactoringMessages.getString("ChangeParametersControl.buttons.move_up"), true);
        this.fDownButton = this.createButton(buttonComposite, RefactoringMessages.getString("ChangeParametersControl.buttons.move_down"), false);
        if (this.fCanAddParameters) {
            this.addSpacer(buttonComposite);
            this.fRemoveButton = this.createRemoveButton(buttonComposite);
        }
        this.updateButtonsEnabledState();
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 5;
        label.setLayoutData((Object)gd);
    }

    private void updateButtonsEnabledState() {
        this.fUpButton.setEnabled(this.canMove(true));
        this.fDownButton.setEnabled(this.canMove(false));
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.getTableSelectionCount() == 1);
        }
        if (this.fAddButton != null) {
            this.fAddButton.setEnabled(true);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createEditButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.getString("ChangeParametersControl.buttons.edit"));
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void widgetSelected(SelectionEvent e) {
                ISelection selection;
                block5: {
                    block4: {
                        selection = ChangeParametersControl.this.fTableViewer.getSelection();
                        try {
                            ParameterInfo[] selected = ChangeParametersControl.this.getSelectedItems();
                            Assert.isTrue(selected.length == 1);
                            ParameterInfo parameterInfo = selected[0];
                            int column = ChangeParametersControl.this.getTableCursorColumn();
                            int row = ChangeParametersControl.this.getTableCursorRow();
                            ChangeParametersControl.this.showTableCursor(false);
                            ParameterEditDialog dialog = new ParameterEditDialog(ChangeParametersControl.this.getShell(), parameterInfo, ChangeParametersControl.this.fCanChangeTypesOfOldParameters);
                            if (dialog.open() == 1) {
                                ChangeParametersControl.this.fTableViewer.setSelection(selection);
                                Object var8_8 = null;
                                break block4;
                            }
                            ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                            ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, PROPERTIES);
                            if (column >= 0 && row >= 0) {
                                ChangeParametersControl.this.showTableCursor(true);
                                ChangeParametersControl.this.setTableCursorSelection(row, column);
                            }
                            break block5;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            ChangeParametersControl.this.fTableViewer.refresh();
                            ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                            ChangeParametersControl.this.fTableViewer.setSelection(selection);
                            throw throwable;
                        }
                    }
                    ChangeParametersControl.this.fTableViewer.refresh();
                    ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                    ChangeParametersControl.this.fTableViewer.setSelection(selection);
                    return;
                }
                Object var8_10 = null;
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                ChangeParametersControl.this.fTableViewer.setSelection(selection);
            }
        });
        return button;
    }

    private Button createAddButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.getString("ChangeParametersControl.buttons.add"));
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterInfo newInfo = ParameterInfo.createInfoForAddedParameter();
                ChangeParametersControl.this.fParameterInfos.add(newInfo);
                ChangeParametersControl.this.fListener.parameterAdded(newInfo);
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                int row = ChangeParametersControl.this.getTableItemCount() - 1;
                ChangeParametersControl.this.getTable().setSelection(row);
                ChangeParametersControl.this.updateButtonsEnabledState();
                ChangeParametersControl.this.showTableCursor(true);
                ChangeParametersControl.this.setTableCursorSelection(row, 0);
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.getString("ChangeParametersControl.buttons.remove"));
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeParametersControl.this.getTable().getSelectionIndices()[0];
                ParameterInfo[] selected = ChangeParametersControl.this.getSelectedItems();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i].isAdded()) {
                        ChangeParametersControl.this.fParameterInfos.remove(selected[i]);
                    } else {
                        selected[i].markAsDeleted();
                    }
                    ++i;
                }
                this.restoreSelection(index);
            }

            private void restoreSelection(int index) {
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                int itemCount = ChangeParametersControl.this.getTableItemCount();
                if (itemCount != 0) {
                    if (index >= itemCount) {
                        index = itemCount - 1;
                    }
                    ChangeParametersControl.this.getTable().setSelection(index);
                    ChangeParametersControl.this.setTableCursorSelection(index, 0);
                    ChangeParametersControl.this.showTableCursor(true);
                } else {
                    ChangeParametersControl.this.showTableCursor(false);
                }
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private Button createButton(Composite buttonComposite, String text, final boolean up) {
        Button button = new Button(buttonComposite, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection savedSelection = ChangeParametersControl.this.fTableViewer.getSelection();
                if (savedSelection == null) {
                    return;
                }
                ParameterInfo[] selection = ChangeParametersControl.this.getSelectedItems();
                if (selection.length == 0) {
                    return;
                }
                int column = ChangeParametersControl.this.getTableCursorColumn();
                Object element = null;
                int r = ChangeParametersControl.this.getTableCursorRow();
                if (r >= 0) {
                    element = ChangeParametersControl.this.fTableViewer.getElementAt(r);
                }
                if (up) {
                    ChangeParametersControl.this.moveUp(selection);
                } else {
                    ChangeParametersControl.this.moveDown(selection);
                }
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                ChangeParametersControl.this.fTableViewer.setSelection(savedSelection);
                ChangeParametersControl.this.fListener.parameterListChanged();
                Widget item = ChangeParametersControl.this.fTableViewer.testFindItem(element);
                int row = 0;
                if (item instanceof TableItem && (row = ChangeParametersControl.this.getTable().indexOf((TableItem)item)) < 0) {
                    row = 0;
                }
                ChangeParametersControl.this.setTableCursorSelection(row, column);
            }
        });
        return button;
    }

    private void showTableCursor(boolean show) {
        if (show) {
            if (this.fTableCursor == null || this.fTableCursor.isDisposed()) {
                this.addTableCursor(this.fTableViewer.getTable());
            }
            this.fTableCursor.setVisible(true);
        } else {
            if (this.fTableCursor != null && !this.fTableCursor.isDisposed()) {
                this.fTableCursor.setVisible(false);
                this.fTableCursor.dispose();
            }
            this.fTableCursor = null;
        }
    }

    private void setTableCursorSelection(int row, int column) {
        if (this.fTableCursor != null && !this.fTableCursor.isDisposed()) {
            this.fTableCursor.setSelection(row, column);
        }
    }

    private void setTableCursorVisible(boolean visible) {
        if (this.fTableCursor != null && !this.fTableCursor.isDisposed()) {
            this.fTableCursor.setVisible(visible);
        }
    }

    private int getTableCursorColumn() {
        if (this.fTableCursor != null && !this.fTableCursor.isDisposed()) {
            return this.fTableCursor.getColumn();
        }
        return -1;
    }

    private int getTableCursorRow() {
        if (this.fTableCursor != null && !this.fTableCursor.isDisposed()) {
            TableItem item = this.fTableCursor.getRow();
            return this.getTable().indexOf(item);
        }
        return -1;
    }

    private void addCellEditors() {
        final CellEditor[] editors = new CellEditor[PROPERTIES.length];
        class AutoApplyTextCellEditor
        extends TextCellEditor {
            public AutoApplyTextCellEditor(Composite parent) {
                super(parent);
            }

            public void fireApplyEditorValue() {
                super.fireApplyEditorValue();
            }
        }
        editors[0] = new AutoApplyTextCellEditor((Composite)this.getTable());
        editors[0].getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ((AutoApplyTextCellEditor)editors[0]).fireApplyEditorValue();
            }
        });
        editors[1] = new AutoApplyTextCellEditor((Composite)this.getTable());
        editors[1].getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ((AutoApplyTextCellEditor)editors[1]).fireApplyEditorValue();
            }
        });
        editors[2] = new AutoApplyTextCellEditor((Composite)this.getTable());
        editors[2].getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ((AutoApplyTextCellEditor)editors[2]).fireApplyEditorValue();
            }
        });
        this.fTableViewer.setCellEditors(editors);
        this.fTableViewer.setColumnProperties(PROPERTIES);
        this.fTableViewer.setCellModifier((ICellModifier)new ParametersCellModifier());
    }

    private void moveUp(ParameterInfo[] selection) {
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(selection));
    }

    private void moveDown(ParameterInfo[] selection) {
        Collections.reverse(this.fParameterInfos);
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(selection));
        Collections.reverse(this.fParameterInfos);
    }

    private static void moveUp(List elements, List move) {
        ArrayList res = new ArrayList(elements.size());
        Object floating = null;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object curr = iter.next();
            if (move.contains(curr)) {
                res.add(curr);
                continue;
            }
            if (floating != null) {
                res.add(floating);
            }
            floating = curr;
        }
        if (floating != null) {
            res.add(floating);
        }
        elements.clear();
        iter = res.iterator();
        while (iter.hasNext()) {
            elements.add(iter.next());
        }
    }

    private boolean canMove(boolean up) {
        List notDeleted = this.getNotDeletedInfos();
        if (notDeleted == null || notDeleted.size() == 0) {
            return false;
        }
        int[] indc = this.getTable().getSelectionIndices();
        if (indc.length == 0) {
            return false;
        }
        int invalid = up ? 0 : notDeleted.size() - 1;
        int i = 0;
        while (i < indc.length) {
            if (indc[i] == invalid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List getNotDeletedInfos() {
        if (this.fParameterInfos == null) {
            return null;
        }
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(this.fParameterInfos.size());
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private static class ParameterInfoContentProvider
    implements IStructuredContentProvider {
        ParameterInfoContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.removeMarkedAsDeleted((List)inputElement);
        }

        private ParameterInfo[] removeMarkedAsDeleted(List paramInfos) {
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(paramInfos.size());
            Iterator iter = paramInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo info = (ParameterInfo)iter.next();
                if (info.isDeleted()) continue;
                result.add(info);
            }
            return result.toArray(new ParameterInfo[result.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ParameterInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ParameterInfoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ParameterInfo info = (ParameterInfo)element;
            if (columnIndex == 0) {
                return info.getNewTypeName();
            }
            if (columnIndex == 1) {
                return info.getNewName();
            }
            if (columnIndex == 2) {
                return info.getDefaultValue();
            }
            Assert.isTrue(false);
            return "";
        }
    }

    private class ParametersCellModifier
    implements ICellModifier {
        ParametersCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            Assert.isTrue(element instanceof ParameterInfo);
            if (property.equals(PROPERTIES[0])) {
                return ChangeParametersControl.this.fCanChangeTypesOfOldParameters;
            }
            if (property.equals(PROPERTIES[1])) {
                return ChangeParametersControl.this.fCanChangeParameterNames;
            }
            if (property.equals(PROPERTIES[2])) {
                return ((ParameterInfo)element).isAdded();
            }
            Assert.isTrue(false);
            return false;
        }

        public Object getValue(Object element, String property) {
            Assert.isTrue(element instanceof ParameterInfo);
            if (property.equals(PROPERTIES[0])) {
                return ((ParameterInfo)element).getNewTypeName();
            }
            if (property.equals(PROPERTIES[1])) {
                return ((ParameterInfo)element).getNewName();
            }
            if (property.equals(PROPERTIES[2])) {
                return ((ParameterInfo)element).getDefaultValue();
            }
            Assert.isTrue(false);
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (!(element instanceof TableItem)) {
                return;
            }
            Object data = ((TableItem)element).getData();
            if (!(data instanceof ParameterInfo)) {
                return;
            }
            ParameterInfo parameterInfo = (ParameterInfo)data;
            if (property.equals(PROPERTIES[1])) {
                parameterInfo.setNewName((String)value);
            } else if (property.equals(PROPERTIES[2])) {
                parameterInfo.setDefaultValue((String)value);
            } else if (property.equals(PROPERTIES[0])) {
                parameterInfo.setNewTypeName((String)value);
            } else {
                Assert.isTrue(false);
            }
            ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
            ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, new String[]{property});
        }
    }
}

