/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

class ChangeElementLabelProvider
extends LabelProvider {
    private int fJavaElementFlags;
    private JavaElementLabelProvider fJavaElementLabelProvider;
    private Map fDescriptorImageMap = new HashMap();
    private boolean fShowQualification = true;

    public ChangeElementLabelProvider(int javaElementFlags) {
        this.fJavaElementFlags = javaElementFlags;
        this.fJavaElementLabelProvider = new JavaElementLabelProvider(javaElementFlags);
    }

    public void setShowQualification(boolean showQualification) {
        this.fShowQualification = showQualification;
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
        this.fireLabelProviderChanged(event);
    }

    public Image getImage(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange element = ((DefaultChangeElement)object).getChange();
            return this.doGetImage(element);
        }
        if (object instanceof TextEditChangeElement) {
            TextChange.EditChange element = ((TextEditChangeElement)object).getTextEditChange();
            return this.doGetImage(element);
        }
        if (object instanceof PseudoJavaChangeElement) {
            PseudoJavaChangeElement element = (PseudoJavaChangeElement)object;
            return this.fJavaElementLabelProvider.getImage(element.getJavaElement());
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange change = ((DefaultChangeElement)object).getChange();
            if (!this.fShowQualification) {
                return change.getName();
            }
            if (change instanceof TextFileChange) {
                IFile file = ((TextFileChange)change).getFile();
                return RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormat", new String[]{file.getName(), this.getPath(file)});
            }
            return change.getName();
        }
        if (object instanceof TextEditChangeElement) {
            ChangeElement parent;
            TextEditChangeElement element = (TextEditChangeElement)object;
            String result = element.getTextEditChange().getName();
            if ((this.fJavaElementFlags & 0x800) != 0 && (parent = this.getParent(element)) != null) {
                result = RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormatEdit", new String[]{this.getText(parent), result});
            }
            return result;
        }
        if (object instanceof PseudoJavaChangeElement) {
            PseudoJavaChangeElement element = (PseudoJavaChangeElement)object;
            return this.fJavaElementLabelProvider.getText(element.getJavaElement());
        }
        return super.getText(object);
    }

    public void dispose() {
        Iterator iter = this.fDescriptorImageMap.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        super.dispose();
    }

    private Image doGetImage(Object element) {
        Image image;
        ImageDescriptor descriptor = null;
        if (descriptor == null) {
            descriptor = element instanceof TextEditChangeElement ? JavaPluginImages.DESC_OBJS_TEXT_EDIT : (element instanceof ICompositeChange ? JavaPluginImages.DESC_OBJS_COMPOSITE_CHANGE : (element instanceof CompilationUnitChange ? JavaPluginImages.DESC_OBJS_CU_CHANGE : (element instanceof TextFileChange ? JavaPluginImages.DESC_OBJS_FILE_CHANGE : JavaPluginImages.DESC_OBJS_DEFAULT_CHANGE)));
        }
        if ((image = (Image)this.fDescriptorImageMap.get(descriptor)) == null) {
            image = descriptor.createImage();
            this.fDescriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    private String getPath(IFile file) {
        StringBuffer result = new StringBuffer(file.getProject().getName());
        String projectRelativePath = file.getParent().getProjectRelativePath().toString();
        if (projectRelativePath.length() > 0) {
            result.append('/');
            result.append(projectRelativePath);
        }
        return result.toString();
    }

    private ChangeElement getParent(TextEditChangeElement element) {
        ChangeElement parent = element.getParent();
        while (parent != null && !(parent instanceof PseudoJavaChangeElement) && !(parent instanceof DefaultChangeElement)) {
            parent = parent.getParent();
        }
        return parent;
    }
}

