/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class OptionsConfigurationBlock {
    protected Map fWorkingValues;
    protected ArrayList fCheckBoxes;
    protected ArrayList fComboBoxes;
    protected ArrayList fTextBoxes;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected IJavaProject fProject;
    private Shell fShell;

    public OptionsConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        this.fContext = context;
        this.fProject = project;
        this.fWorkingValues = this.getOptions(true);
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
    }

    protected abstract String[] getAllKeys();

    protected Map getOptions(boolean inheritJavaCoreOptions) {
        if (this.fProject != null) {
            return this.fProject.getOptions(inheritJavaCoreOptions);
        }
        return JavaCore.getOptions();
    }

    protected Map getDefaultOptions() {
        return JavaCore.getDefaultOptions();
    }

    public final boolean hasProjectSpecificOptions() {
        if (this.fProject != null) {
            Map settings = this.fProject.getOptions(false);
            String[] allKeys = this.getAllKeys();
            int i = 0;
            while (i < allKeys.length) {
                if (settings.get(allKeys[i]) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected final void setOptions(Map map) {
        if (this.fProject != null) {
            this.fProject.setOptions(map);
        } else {
            JavaCore.setOptions((Hashtable)((Hashtable)map));
        }
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected void addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        String currValue = (String)this.fWorkingValues.get(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
    }

    protected void addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        comboBox.addSelectionListener(this.getSelectionListener());
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
    }

    protected Text addTextField(Composite parent, String label, String key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        String currValue = (String)this.fWorkingValues.get(key);
        textBox.setText(currValue);
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        this.fWorkingValues.put(data.getKey(), newValue);
        this.validateSettings(data.getKey(), newValue);
    }

    protected void textChanged(Text textControl) {
        String key = (String)textControl.getData();
        String number = textControl.getText();
        this.fWorkingValues.put(key, number);
        this.validateSettings(key, number);
    }

    protected boolean checkValue(String key, String value) {
        return value.equals(this.fWorkingValues.get(key));
    }

    protected abstract void validateSettings(String var1, String var2);

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    public boolean performOk(boolean enabled) {
        String[] allKeys = this.getAllKeys();
        Map actualOptions = this.getOptions(false);
        boolean hasChanges = false;
        int i = 0;
        while (i < allKeys.length) {
            String key = allKeys[i];
            String oldVal = (String)actualOptions.get(key);
            String val = null;
            if (enabled) {
                val = (String)this.fWorkingValues.get(key);
                if (!val.equals(oldVal)) {
                    hasChanges = true;
                    actualOptions.put(key, val);
                }
            } else if (oldVal != null) {
                actualOptions.remove(key);
                hasChanges = true;
            }
            ++i;
        }
        if (hasChanges) {
            boolean doBuild = false;
            String[] strings = this.getFullBuildDialogStrings(this.fProject == null);
            if (strings != null) {
                MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = dialog.open();
                if (res == 0) {
                    doBuild = true;
                } else if (res != 1) {
                    return false;
                }
            }
            this.setOptions(actualOptions);
            if (doBuild) {
                this.doFullBuild();
            }
        }
        return true;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    protected void doFullBuild() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("", 1);
                    try {
                        try {
                            if (OptionsConfigurationBlock.this.fProject != null) {
                                monitor.setTaskName(PreferencesMessages.getFormattedString("OptionsConfigurationBlock.buildproject.taskname", OptionsConfigurationBlock.this.fProject.getElementName()));
                                OptionsConfigurationBlock.this.fProject.getProject().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.setTaskName(PreferencesMessages.getString("OptionsConfigurationBlock.buildall.taskname"));
                                JavaPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var3_5 = null;
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String title = PreferencesMessages.getString("OptionsConfigurationBlock.builderror.title");
            String message = PreferencesMessages.getString("OptionsConfigurationBlock.builderror.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    public void performDefaults() {
        this.fWorkingValues = this.getDefaultOptions();
        this.updateControls();
        this.validateSettings(null, null);
    }

    protected void updateControls() {
        String currValue;
        ControlData data;
        Button curr;
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            data = (ControlData)(curr = (Button)this.fCheckBoxes.get(i)).getData();
            curr.setSelection(data.getSelection(currValue = (String)this.fWorkingValues.get(data.getKey())) == 0);
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            curr = (Combo)this.fComboBoxes.get(i);
            data = (ControlData)curr.getData();
            currValue = (String)this.fWorkingValues.get(data.getKey());
            curr.select(data.getSelection(currValue));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            curr = (Text)this.fTextBoxes.get(i);
            String key = (String)curr.getData();
            currValue = (String)this.fWorkingValues.get(key);
            curr.setText(currValue);
            --i;
        }
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            int i = 0;
            while (i < this.fValues.length) {
                if (value.equals(this.fValues[i])) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException();
        }
    }
}

