/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JavadocConfigurationBlock {
    private StringButtonDialogField fJavaDocField;
    private URL fInitialURL;
    private Button fValidateButton;
    private Shell fShell;
    private IStatusChangeListener fContext;
    private URL fJavaDocLocation;

    public JavadocConfigurationBlock(Shell shell, IStatusChangeListener context, URL initURL) {
        this.fShell = shell;
        this.fContext = context;
        this.fInitialURL = initURL;
    }

    public Control createContents(Composite parent) {
        final Composite topComp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topComp.setLayout((Layout)topLayout);
        JDocConfigurationAdapter adapter = new JDocConfigurationAdapter();
        this.fJavaDocField = new StringButtonDialogField(adapter);
        this.fJavaDocField.setDialogFieldListener(adapter);
        this.fJavaDocField.setLabelText(PreferencesMessages.getString("JavadocConfigurationBlock.location.label"));
        this.fJavaDocField.setButtonLabel(PreferencesMessages.getString("JavadocConfigurationBlock.location.button"));
        this.fJavaDocField.doFillIntoGrid(topComp, 3);
        PixelConverter converter = new PixelConverter((Control)topComp);
        LayoutUtil.setWidthHint((Control)this.fJavaDocField.getTextControl(null), converter.convertWidthInCharsToPixels(50));
        LayoutUtil.setHorizontalGrabbing((Control)this.fJavaDocField.getTextControl(null));
        DialogField.createEmptySpace(topComp, 2);
        this.fValidateButton = new Button(topComp, 8);
        this.fValidateButton.setText(PreferencesMessages.getString("JavadocConfigurationBlock.ValidateButton.label"));
        GridData gd = new GridData(128);
        this.fValidateButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fValidateButton);
        this.fValidateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EntryValidator validator = new EntryValidator();
                BusyIndicator.showWhile((Display)topComp.getDisplay(), (Runnable)validator);
            }
        });
        this.setValues();
        return topComp;
    }

    private void setValues() {
        String initialValue = this.fInitialURL != null ? this.fInitialURL.toExternalForm() : "";
        this.fJavaDocField.setText(initialValue);
    }

    public void setFocus() {
        this.fJavaDocField.postSetFocusOnDialogField(this.fShell.getDisplay());
    }

    public void performDefaults() {
        this.setValues();
    }

    public URL getJavadocLocation() {
        return this.fJavaDocLocation;
    }

    private void jdocChangeControlPressed(DialogField field) {
        URL jdocURL;
        if (field == this.fJavaDocField && (jdocURL = this.chooseJavaDocLocation()) != null) {
            this.fJavaDocField.setText(jdocURL.toExternalForm());
        }
    }

    private void jdocDialogFieldChanged(DialogField field) {
        if (field == this.fJavaDocField) {
            IStatus status = this.updateJavaDocLocationStatus();
            this.fValidateButton.setEnabled(!status.matches(4) && this.fJavaDocField.getText().length() > 0);
            this.fContext.statusChanged(status);
        }
    }

    private URL chooseJavaDocLocation() {
        String initPath = "";
        if (this.fJavaDocLocation != null && "file".equals(this.fJavaDocLocation.getProtocol())) {
            initPath = new File(this.fJavaDocLocation.getFile()).getPath();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setText(PreferencesMessages.getString("JavadocConfigurationBlock.javadocLocationDialog.label"));
        dialog.setMessage(PreferencesMessages.getString("JavadocConfigurationBlock.javadocLocationDialog.message"));
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        if (res != null) {
            try {
                return new File(res).toURL();
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private IStatus updateJavaDocLocationStatus() {
        StatusInfo status = new StatusInfo();
        this.fJavaDocLocation = null;
        String jdocLocation = this.fJavaDocField.getText();
        if (jdocLocation.length() > 0) {
            try {
                URL url = new URL(jdocLocation);
                if ("file".equals(url.getProtocol())) {
                    if (url.getFile() == null) {
                        status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafolder"));
                        return status;
                    }
                    File dir = new File(url.getFile());
                    if (!dir.isDirectory()) {
                        status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.error.notafolder"));
                        return status;
                    }
                    File packagesFile = new File(dir, "package-list");
                    if (!packagesFile.exists()) {
                        status.setWarning(PreferencesMessages.getString("JavadocConfigurationBlock.warning.packagelistnotfound"));
                    }
                }
                this.fJavaDocLocation = url;
            }
            catch (MalformedURLException malformedURLException) {
                status.setError(PreferencesMessages.getString("JavadocConfigurationBlock.MalformedURL.error"));
                return status;
            }
        }
        return status;
    }

    private class EntryValidator
    implements Runnable {
        private String fInvalidMessage = PreferencesMessages.getString("JavadocConfigurationBlock.InvalidLocation.message");
        private String fValidMessage = PreferencesMessages.getString("JavadocConfigurationBlock.ValidLocation.message");
        private String fTitle = PreferencesMessages.getString("JavadocConfigurationBlock.MessageDialog.title");

        EntryValidator() {
        }

        public void run() {
            Path path = new Path(JavadocConfigurationBlock.this.fJavaDocField.getText());
            IPath index = path.append("index.html");
            IPath packagelist = path.append("package-list");
            String message = PreferencesMessages.getString("JavadocConfigurationBlock.UnableToValidateLocation.message");
            try {
                URL indexURL = new URL(index.toString());
                URL packagelistURL = new URL(packagelist.toString());
                String protocol = indexURL.getProtocol();
                if (protocol.equals("http")) {
                    this.validateURL(indexURL, packagelistURL);
                } else if (protocol.equals("file")) {
                    this.validateFile(indexURL, packagelistURL);
                } else {
                    MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)message);
                }
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)message);
            }
        }

        public void validateFile(URL indexURL, URL packagelisURL) {
            File packaglistFile;
            File indexFile = new File(indexURL.getFile());
            if (indexFile.exists() && (packaglistFile = new File(packagelisURL.getFile())).exists()) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(indexURL);
                }
                return;
            }
            MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
        }

        public void spawnInBrowser(URL url) {
            OpenBrowserUtil.open(url, JavadocConfigurationBlock.this.fShell, this.fTitle);
        }

        private void validateURL(URL indexURL, URL packagelistURL) {
            block17: {
                InputStream in1 = null;
                InputStream in2 = null;
                try {
                    try {
                        in1 = indexURL.openConnection().getInputStream();
                        in2 = packagelistURL.openConnection().getInputStream();
                        if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                            this.spawnInBrowser(indexURL);
                        }
                    }
                    catch (IOException iOException) {
                        MessageDialog.openInformation((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (in1 != null) {
                        try {
                            in1.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                Object var5_7 = null;
                if (in1 != null) {
                    try {
                        in1.close();
                    }
                    catch (IOException iOException) {}
                }
                if (in2 == null) break block17;
                try {
                    in2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class JDocConfigurationAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        JDocConfigurationAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            JavadocConfigurationBlock.this.jdocChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            JavadocConfigurationBlock.this.jdocDialogFieldChanged(field);
        }
    }
}

