/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaPreferencesSettings {
    public static CodeGenerationSettings getCodeGenerationSettings() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = store.getBoolean("org.eclipse.jdt.ui.javadoc");
        res.importOrder = JavaPreferencesSettings.getImportOrderPreference(store);
        res.importThreshold = JavaPreferencesSettings.getImportNumberThreshold(store);
        res.tabWidth = JavaCore.getPlugin().getPluginPreferences().getInt("org.eclipse.jdt.core.formatter.tabulation.size");
        return res;
    }

    public static int getImportNumberThreshold(IPreferenceStore prefs) {
        int threshold = prefs.getInt("org.eclipse.jdt.ui.ondemandthreshold");
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public static String[] getImportOrderPreference(IPreferenceStore prefs) {
        String str = prefs.getString("org.eclipse.jdt.ui.importorder");
        if (str != null) {
            return JavaPreferencesSettings.unpackList(str, ";");
        }
        return new String[0];
    }

    private static String[] unpackList(String str, String separator) {
        StringTokenizer tok = new StringTokenizer(str, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

